/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cuc.daithi.BSW.verify;

import ie.ucc.cuc.daithi.BSW.verify.SymbolTable;
import ie.ucc.cuc.daithi.BSW.verify.TypeException;
import ie.ucc.cuc.daithi.BSW.verify.analysis.DepthFirstAdapter;
import ie.ucc.cuc.daithi.BSW.verify.node.AAtomicMessageMessage;
import ie.ucc.cuc.daithi.BSW.verify.node.AChannel;
import ie.ucc.cuc.daithi.BSW.verify.node.ADeclarations;
import ie.ucc.cuc.daithi.BSW.verify.node.AFormulaVariable;
import ie.ucc.cuc.daithi.BSW.verify.node.AMessageVariable;
import ie.ucc.cuc.daithi.BSW.verify.node.ANonce;
import ie.ucc.cuc.daithi.BSW.verify.node.APrincipal;

public class TypeChecker
extends DepthFirstAdapter {
    private SymbolTable principals = new SymbolTable();
    private SymbolTable nonces = new SymbolTable();
    private SymbolTable channels = new SymbolTable();
    private SymbolTable messages = new SymbolTable();
    private SymbolTable formulae = new SymbolTable();
    private boolean declaring = false;

    public SymbolTable getFormulaeSymbolTable() {
        return this.formulae;
    }

    public SymbolTable getNoncesSymbolTable() {
        return this.nonces;
    }

    public SymbolTable getChannelSymbolTable() {
        return this.channels;
    }

    public SymbolTable getPrincipalsSymbolTable() {
        return this.principals;
    }

    public SymbolTable getMessagesSymbolTable() {
        return this.messages;
    }

    public void inADeclarations(ADeclarations aDeclarations) {
        this.declaring = true;
        this.defaultIn(aDeclarations);
    }

    public void outADeclarations(ADeclarations aDeclarations) {
        this.declaring = false;
        this.defaultOut(aDeclarations);
    }

    public void inAAtomicMessageMessage(AAtomicMessageMessage aAtomicMessageMessage) {
        String string = aAtomicMessageMessage.getIdentifierSym().toString();
        if (!(this.formulae.hasSymbol(string) || this.principals.hasSymbol(string) || this.nonces.hasSymbol(string) || this.channels.hasSymbol(string) || this.messages.hasSymbol(string))) {
            throw new TypeException("Undeclared Variable " + string);
        }
        this.defaultIn(aAtomicMessageMessage);
    }

    public void inAFormulaVariable(AFormulaVariable aFormulaVariable) {
        if (this.declaring) {
            this.formulae.addSymbol(aFormulaVariable.getIdentifierSym().toString());
        } else if (!this.formulae.hasSymbol(aFormulaVariable.getIdentifierSym().toString())) {
            throw new TypeException("Undeclared Formula Variable " + aFormulaVariable.getIdentifierSym().toString());
        }
        this.defaultIn(aFormulaVariable);
    }

    public void inAMessageVariable(AMessageVariable aMessageVariable) {
        if (this.declaring) {
            this.messages.addSymbol(aMessageVariable.getIdentifierSym().toString());
        } else if (!this.messages.hasSymbol(aMessageVariable.getIdentifierSym().toString())) {
            throw new TypeException("Undeclared Message Variable " + aMessageVariable.getIdentifierSym().toString());
        }
        this.defaultIn(aMessageVariable);
    }

    public void inAPrincipal(APrincipal aPrincipal) {
        if (this.declaring) {
            this.principals.addSymbol(aPrincipal.getIdentifierSym().toString());
        } else if (!this.principals.hasSymbol(aPrincipal.getIdentifierSym().toString())) {
            throw new TypeException("Undeclared Principal Variable " + aPrincipal.getIdentifierSym().toString());
        }
        this.defaultIn(aPrincipal);
    }

    public void inAChannel(AChannel aChannel) {
        if (this.declaring) {
            this.channels.addSymbol(aChannel.getIdentifierSym().toString());
        } else if (!this.channels.hasSymbol(aChannel.getIdentifierSym().toString())) {
            throw new TypeException("Undeclared Channel Variable " + aChannel.getIdentifierSym().toString());
        }
        this.defaultIn(aChannel);
    }

    public void inANonce(ANonce aNonce) {
        if (this.declaring) {
            this.nonces.addSymbol(aNonce.getIdentifierSym().toString());
        } else if (!this.nonces.hasSymbol(aNonce.getIdentifierSym().toString())) {
            throw new TypeException("Undeclared Nonce Variable " + aNonce.getIdentifierSym().toString());
        }
        this.defaultIn(aNonce);
    }
}

