/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cuc.daithi.BSW.verify;

import ie.ucc.cuc.daithi.BSW.logic.BSWProtocol;
import ie.ucc.cuc.daithi.BSW.logic.FormulaVar;
import ie.ucc.cuc.daithi.BSW.logic.MessageVar;
import ie.ucc.cuc.daithi.BSW.verify.EntitySymbolTable;
import ie.ucc.cuc.daithi.BSW.verify.GeneratedBSWProtocol;
import ie.ucc.cuc.daithi.BSW.verify.IntermediateFormatGenerationException;
import ie.ucc.cuc.daithi.BSW.verify.SymbolTable;
import ie.ucc.cuc.daithi.BSW.verify.TypeChecker;
import ie.ucc.cuc.daithi.BSW.verify.analysis.DepthFirstAdapter;
import ie.ucc.cuc.daithi.BSW.verify.node.AAndNonVariableFormula;
import ie.ucc.cuc.daithi.BSW.verify.node.AAssumptions;
import ie.ucc.cuc.daithi.BSW.verify.node.ABelievesNonVariableFormula;
import ie.ucc.cuc.daithi.BSW.verify.node.ACompositeMessage;
import ie.ucc.cuc.daithi.BSW.verify.node.ADeclarations;
import ie.ucc.cuc.daithi.BSW.verify.node.AEnumeratedSetSet;
import ie.ucc.cuc.daithi.BSW.verify.node.AEqualsSetFormula;
import ie.ucc.cuc.daithi.BSW.verify.node.AFreshNonVariableFormula;
import ie.ucc.cuc.daithi.BSW.verify.node.AGoals;
import ie.ucc.cuc.daithi.BSW.verify.node.AImpliesNonVariableFormula;
import ie.ucc.cuc.daithi.BSW.verify.node.AInSetFormula;
import ie.ucc.cuc.daithi.BSW.verify.node.AMessageOnChannelMessage;
import ie.ucc.cuc.daithi.BSW.verify.node.AOrNonVariableFormula;
import ie.ucc.cuc.daithi.BSW.verify.node.AProtocol;
import ie.ucc.cuc.daithi.BSW.verify.node.AReadSetChannelSet;
import ie.ucc.cuc.daithi.BSW.verify.node.ARecentlySaidNonVariableFormula;
import ie.ucc.cuc.daithi.BSW.verify.node.ASaidNonVariableFormula;
import ie.ucc.cuc.daithi.BSW.verify.node.ASeesNonVariableFormula;
import ie.ucc.cuc.daithi.BSW.verify.node.ASeesOnChannelNonVariableFormula;
import ie.ucc.cuc.daithi.BSW.verify.node.ASeesViaChannelNonVariableFormula;
import ie.ucc.cuc.daithi.BSW.verify.node.AWriteSetChannelSet;
import ie.ucc.cuc.daithi.BSW.verify.node.TIdentifierSym;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import tc.expr.Expr;
import tc.expr.Var;

public class IntermediateFormatGenerator
extends DepthFirstAdapter {
    private EntitySymbolTable entities;
    private int numPrincipals;
    private SymbolTable messages;
    private SymbolTable formulae;
    private boolean inDeclaration = false;
    private boolean inAssumptions = false;
    private boolean inProtocol = false;
    private boolean inGoals = false;
    private Vector assumptionFormulae = new Vector();
    private Vector protocolFormulae = new Vector();
    private Vector goalFormulae = new Vector();
    private Stack parameterStack = new Stack();
    private HashMap bindings = new HashMap();

    public IntermediateFormatGenerator(TypeChecker typeChecker) {
        this.messages = typeChecker.getMessagesSymbolTable();
        this.formulae = typeChecker.getFormulaeSymbolTable();
        Iterator iterator = typeChecker.getPrincipalsSymbolTable().getSymbols();
        this.numPrincipals = typeChecker.getPrincipalsSymbolTable().size();
        this.entities = new EntitySymbolTable();
        this.entities.addAll(iterator);
        iterator = typeChecker.getNoncesSymbolTable().getSymbols();
        this.entities.addAll(iterator);
        iterator = typeChecker.getChannelSymbolTable().getSymbols();
        this.entities.addAll(iterator);
    }

    public BSWProtocol getProtocol() {
        Iterator iterator = this.entities.getExpressions();
        Vector vector = new Vector();
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        return new GeneratedBSWProtocol(vector, this.protocolFormulae, this.assumptionFormulae, this.goalFormulae, this.numPrincipals);
    }

    private void appendFormula(Expr expr) {
        if (this.inDeclaration) {
            throw new IntermediateFormatGenerationException("Generated formula in declarations block");
        }
        if (this.inAssumptions) {
            this.assumptionFormulae.addElement(expr);
        } else if (this.inProtocol) {
            this.protocolFormulae.addElement(expr);
        } else if (this.inGoals) {
            this.goalFormulae.addElement(expr);
        } else {
            throw new IntermediateFormatGenerationException("Generated formula outside blocks");
        }
        this.bindings.clear();
    }

    public void inADeclarations(ADeclarations aDeclarations) {
        this.inDeclaration = true;
        this.defaultIn(aDeclarations);
    }

    public void outADeclarations(ADeclarations aDeclarations) {
        this.defaultOut(aDeclarations);
        this.inDeclaration = false;
    }

    public void inAAssumptions(AAssumptions aAssumptions) {
        this.inAssumptions = true;
        this.defaultIn(aAssumptions);
    }

    public void outAAssumptions(AAssumptions aAssumptions) {
        this.defaultOut(aAssumptions);
        this.inAssumptions = false;
    }

    public void inAProtocol(AProtocol aProtocol) {
        this.inProtocol = true;
        this.defaultIn(aProtocol);
    }

    public void outAProtocol(AProtocol aProtocol) {
        this.defaultOut(aProtocol);
        this.inProtocol = false;
    }

    public void inAGoals(AGoals aGoals) {
        this.inGoals = true;
        this.defaultIn(aGoals);
    }

    public void outAGoals(AGoals aGoals) {
        this.defaultOut(aGoals);
        this.inGoals = false;
    }

    public void inASeesNonVariableFormula(ASeesNonVariableFormula aSeesNonVariableFormula) {
        this.parameterStack.push(null);
        this.defaultIn(aSeesNonVariableFormula);
    }

    public void outASeesNonVariableFormula(ASeesNonVariableFormula aSeesNonVariableFormula) {
        this.defaultOut(aSeesNonVariableFormula);
        Expr expr = (Expr)this.parameterStack.pop();
        Expr expr2 = (Expr)this.parameterStack.pop();
        Expr expr3 = BSWProtocol.sees(expr2, expr);
        if (this.parameterStack.pop() != null) {
            throw new IntermediateFormatGenerationException("Unexhausted Formula Frame in generation");
        }
        if (this.parameterStack.isEmpty()) {
            this.appendFormula(expr3);
        } else {
            this.parameterStack.push(expr3);
        }
    }

    public void inASeesOnChannelNonVariableFormula(ASeesOnChannelNonVariableFormula aSeesOnChannelNonVariableFormula) {
        this.parameterStack.push(null);
        this.defaultIn(aSeesOnChannelNonVariableFormula);
    }

    public void outASeesOnChannelNonVariableFormula(ASeesOnChannelNonVariableFormula aSeesOnChannelNonVariableFormula) {
        this.defaultOut(aSeesOnChannelNonVariableFormula);
        Expr expr = (Expr)this.parameterStack.pop();
        Expr expr2 = (Expr)this.parameterStack.pop();
        Expr expr3 = (Expr)this.parameterStack.pop();
        Expr expr4 = BSWProtocol.seesOnChannel(expr3, expr2, expr);
        if (this.parameterStack.pop() != null) {
            throw new IntermediateFormatGenerationException("Unexhausted Formula Frame in generation");
        }
        if (this.parameterStack.isEmpty()) {
            this.appendFormula(expr4);
        } else {
            this.parameterStack.push(expr4);
        }
    }

    public void inASeesViaChannelNonVariableFormula(ASeesViaChannelNonVariableFormula aSeesViaChannelNonVariableFormula) {
        this.parameterStack.push(null);
        this.defaultIn(aSeesViaChannelNonVariableFormula);
    }

    public void outASeesViaChannelNonVariableFormula(ASeesViaChannelNonVariableFormula aSeesViaChannelNonVariableFormula) {
        this.defaultOut(aSeesViaChannelNonVariableFormula);
        Expr expr = (Expr)this.parameterStack.pop();
        Expr expr2 = (Expr)this.parameterStack.pop();
        Expr expr3 = (Expr)this.parameterStack.pop();
        Expr expr4 = BSWProtocol.seesViaChannel(expr3, expr2, expr);
        if (this.parameterStack.pop() != null) {
            throw new IntermediateFormatGenerationException("Unexhausted Formula Frame in generation");
        }
        if (this.parameterStack.isEmpty()) {
            this.appendFormula(expr4);
        } else {
            this.parameterStack.push(expr4);
        }
    }

    public void inAFreshNonVariableFormula(AFreshNonVariableFormula aFreshNonVariableFormula) {
        this.parameterStack.push(null);
        this.defaultIn(aFreshNonVariableFormula);
    }

    public void outAFreshNonVariableFormula(AFreshNonVariableFormula aFreshNonVariableFormula) {
        this.defaultOut(aFreshNonVariableFormula);
        Expr expr = BSWProtocol.fresh((Expr)this.parameterStack.pop());
        if (this.parameterStack.pop() != null) {
            throw new IntermediateFormatGenerationException("Unexhausted Formula Frame in generation");
        }
        if (this.parameterStack.isEmpty()) {
            this.appendFormula(expr);
        } else {
            this.parameterStack.push(expr);
        }
    }

    public void inASaidNonVariableFormula(ASaidNonVariableFormula aSaidNonVariableFormula) {
        this.parameterStack.push(null);
        this.defaultIn(aSaidNonVariableFormula);
    }

    public void outASaidNonVariableFormula(ASaidNonVariableFormula aSaidNonVariableFormula) {
        this.defaultOut(aSaidNonVariableFormula);
        Expr expr = (Expr)this.parameterStack.pop();
        Expr expr2 = (Expr)this.parameterStack.pop();
        Expr expr3 = BSWProtocol.said(expr2, expr);
        if (this.parameterStack.pop() != null) {
            throw new IntermediateFormatGenerationException("Unexhausted Formula Frame in generation");
        }
        if (this.parameterStack.isEmpty()) {
            this.appendFormula(expr3);
        } else {
            this.parameterStack.push(expr3);
        }
    }

    public void inARecentlySaidNonVariableFormula(ARecentlySaidNonVariableFormula aRecentlySaidNonVariableFormula) {
        this.parameterStack.push(null);
        this.defaultIn(aRecentlySaidNonVariableFormula);
    }

    public void outARecentlySaidNonVariableFormula(ARecentlySaidNonVariableFormula aRecentlySaidNonVariableFormula) {
        this.defaultOut(aRecentlySaidNonVariableFormula);
        Expr expr = (Expr)this.parameterStack.pop();
        Expr expr2 = (Expr)this.parameterStack.pop();
        Expr expr3 = BSWProtocol.recentlySaid(expr2, expr);
        if (this.parameterStack.pop() != null) {
            throw new IntermediateFormatGenerationException("Unexhausted Formula Frame in generation");
        }
        if (this.parameterStack.isEmpty()) {
            this.appendFormula(expr3);
        } else {
            this.parameterStack.push(expr3);
        }
    }

    public void inABelievesNonVariableFormula(ABelievesNonVariableFormula aBelievesNonVariableFormula) {
        this.parameterStack.push(null);
        this.defaultIn(aBelievesNonVariableFormula);
    }

    public void outABelievesNonVariableFormula(ABelievesNonVariableFormula aBelievesNonVariableFormula) {
        this.defaultOut(aBelievesNonVariableFormula);
        Expr expr = (Expr)this.parameterStack.pop();
        Expr expr2 = (Expr)this.parameterStack.pop();
        Expr expr3 = BSWProtocol.believes(expr2, expr);
        if (this.parameterStack.pop() != null) {
            throw new IntermediateFormatGenerationException("Unexhausted Formula Frame in generation");
        }
        if (this.parameterStack.isEmpty()) {
            this.appendFormula(expr3);
        } else {
            this.parameterStack.push(expr3);
        }
    }

    public void inAAndNonVariableFormula(AAndNonVariableFormula aAndNonVariableFormula) {
        this.parameterStack.push(null);
        this.defaultIn(aAndNonVariableFormula);
    }

    public void outAAndNonVariableFormula(AAndNonVariableFormula aAndNonVariableFormula) {
        this.defaultOut(aAndNonVariableFormula);
        Expr expr = (Expr)this.parameterStack.pop();
        Expr expr2 = (Expr)this.parameterStack.pop();
        Expr expr3 = BSWProtocol.and(expr2, expr);
        if (this.parameterStack.pop() != null) {
            throw new IntermediateFormatGenerationException("Unexhausted Formula Frame in generation");
        }
        if (this.parameterStack.isEmpty()) {
            this.appendFormula(expr3);
        } else {
            this.parameterStack.push(expr3);
        }
    }

    public void inAOrNonVariableFormula(AOrNonVariableFormula aOrNonVariableFormula) {
        this.parameterStack.push(null);
        this.defaultIn(aOrNonVariableFormula);
    }

    public void outAOrNonVariableFormula(AOrNonVariableFormula aOrNonVariableFormula) {
        this.defaultOut(aOrNonVariableFormula);
        Expr expr = (Expr)this.parameterStack.pop();
        Expr expr2 = (Expr)this.parameterStack.pop();
        Expr expr3 = BSWProtocol.or(expr2, expr);
        if (this.parameterStack.pop() != null) {
            throw new IntermediateFormatGenerationException("Unexhausted Formula Frame in generation");
        }
        if (this.parameterStack.isEmpty()) {
            this.appendFormula(expr3);
        } else {
            this.parameterStack.push(expr3);
        }
    }

    public void inAImpliesNonVariableFormula(AImpliesNonVariableFormula aImpliesNonVariableFormula) {
        this.parameterStack.push(null);
        this.defaultIn(aImpliesNonVariableFormula);
    }

    public void outAImpliesNonVariableFormula(AImpliesNonVariableFormula aImpliesNonVariableFormula) {
        this.defaultOut(aImpliesNonVariableFormula);
        Expr expr = (Expr)this.parameterStack.pop();
        Expr expr2 = (Expr)this.parameterStack.pop();
        Expr expr3 = BSWProtocol.implies(expr2, expr);
        if (this.parameterStack.pop() != null) {
            throw new IntermediateFormatGenerationException("Unexhausted Formula Frame in generation");
        }
        if (this.parameterStack.isEmpty()) {
            this.appendFormula(expr3);
        } else {
            this.parameterStack.push(expr3);
        }
    }

    public void inAInSetFormula(AInSetFormula aInSetFormula) {
        this.parameterStack.push(null);
        this.defaultIn(aInSetFormula);
    }

    public void outAInSetFormula(AInSetFormula aInSetFormula) {
        this.defaultOut(aInSetFormula);
        Expr expr = (Expr)this.parameterStack.pop();
        Expr expr2 = (Expr)this.parameterStack.pop();
        Expr expr3 = BSWProtocol.in(expr2, expr);
        if (this.parameterStack.pop() != null) {
            throw new IntermediateFormatGenerationException("Unexhausted Formula Frame in generation");
        }
        if (this.parameterStack.isEmpty()) {
            this.appendFormula(expr3);
        } else {
            this.parameterStack.push(expr3);
        }
    }

    public void inAEqualsSetFormula(AEqualsSetFormula aEqualsSetFormula) {
        this.parameterStack.push(null);
        this.defaultIn(aEqualsSetFormula);
    }

    public void outAEqualsSetFormula(AEqualsSetFormula aEqualsSetFormula) {
        this.defaultOut(aEqualsSetFormula);
        Expr expr = (Expr)this.parameterStack.pop();
        Expr expr2 = (Expr)this.parameterStack.pop();
        Expr expr3 = BSWProtocol.equals(expr2, expr);
        if (this.parameterStack.pop() != null) {
            throw new IntermediateFormatGenerationException("Unexhausted Formula Frame in generation");
        }
        if (this.parameterStack.isEmpty()) {
            this.appendFormula(expr3);
        } else {
            this.parameterStack.push(expr3);
        }
    }

    public void inAReadSetChannelSet(AReadSetChannelSet aReadSetChannelSet) {
        this.parameterStack.push(null);
        this.defaultIn(aReadSetChannelSet);
    }

    public void outAReadSetChannelSet(AReadSetChannelSet aReadSetChannelSet) {
        this.defaultOut(aReadSetChannelSet);
        Expr expr = BSWProtocol.r((Expr)this.parameterStack.pop());
        if (this.parameterStack.pop() != null) {
            throw new IntermediateFormatGenerationException("Unexhausted Formula Frame in generation");
        }
        if (this.parameterStack.isEmpty()) {
            this.appendFormula(expr);
        } else {
            this.parameterStack.push(expr);
        }
    }

    public void inAWriteSetChannelSet(AWriteSetChannelSet aWriteSetChannelSet) {
        this.parameterStack.push(null);
        this.defaultIn(aWriteSetChannelSet);
    }

    public void outAWriteSetChannelSet(AWriteSetChannelSet aWriteSetChannelSet) {
        this.defaultOut(aWriteSetChannelSet);
        Expr expr = BSWProtocol.w((Expr)this.parameterStack.pop());
        if (this.parameterStack.pop() != null) {
            throw new IntermediateFormatGenerationException("Unexhausted Formula Frame in generation");
        }
        if (this.parameterStack.isEmpty()) {
            this.appendFormula(expr);
        } else {
            this.parameterStack.push(expr);
        }
    }

    public void inAEnumeratedSetSet(AEnumeratedSetSet aEnumeratedSetSet) {
        this.parameterStack.push(null);
        this.defaultIn(aEnumeratedSetSet);
    }

    public void outAEnumeratedSetSet(AEnumeratedSetSet aEnumeratedSetSet) {
        this.defaultOut(aEnumeratedSetSet);
        Vector vector = new Vector();
        Object e = this.parameterStack.pop();
        while (e != null) {
            vector.addElement(e);
            e = this.parameterStack.pop();
        }
        Expr[] exprArray = new Expr[vector.size()];
        Enumeration enumeration = vector.elements();
        int n = exprArray.length - 1;
        while (enumeration.hasMoreElements()) {
            exprArray[n] = (Expr)enumeration.nextElement();
            --n;
        }
        Expr expr = BSWProtocol.enumeratedSet(exprArray);
        if (this.parameterStack.isEmpty()) {
            this.appendFormula(expr);
        } else {
            this.parameterStack.push(expr);
        }
    }

    public void caseTIdentifierSym(TIdentifierSym tIdentifierSym) {
        if (!this.inDeclaration) {
            String string = tIdentifierSym.getText();
            if (this.entities.hasSymbol(string)) {
                this.parameterStack.push(this.entities.getExpression(string));
                return;
            }
            if (this.bindings.containsKey(string)) {
                this.parameterStack.push((Expr)this.bindings.get(string));
                return;
            }
            Var var = null;
            if (this.messages.hasSymbol(string)) {
                var = MessageVar.nextMessageVar();
            } else if (this.formulae.hasSymbol(string)) {
                var = FormulaVar.nextFormulaVar();
            } else {
                throw new IntermediateFormatGenerationException("Unbound variable in intermediate format generation. " + string + ".");
            }
            this.bindings.put(string, var);
            this.parameterStack.push(var);
        }
    }

    public void inAMessageOnChannelMessage(AMessageOnChannelMessage aMessageOnChannelMessage) {
        this.parameterStack.push(null);
        this.defaultIn(aMessageOnChannelMessage);
    }

    public void outAMessageOnChannelMessage(AMessageOnChannelMessage aMessageOnChannelMessage) {
        this.defaultOut(aMessageOnChannelMessage);
        Expr expr = (Expr)this.parameterStack.pop();
        Expr expr2 = (Expr)this.parameterStack.pop();
        Expr expr3 = BSWProtocol.channelMessage(expr2, expr);
        if (this.parameterStack.pop() != null) {
            throw new IntermediateFormatGenerationException("Unexhausted Formula Frame in generation");
        }
        if (this.parameterStack.isEmpty()) {
            this.appendFormula(expr3);
        } else {
            this.parameterStack.push(expr3);
        }
    }

    public void inACompositeMessage(ACompositeMessage aCompositeMessage) {
        this.parameterStack.push(null);
        this.defaultIn(aCompositeMessage);
    }

    public void outACompositeMessage(ACompositeMessage aCompositeMessage) {
        this.defaultOut(aCompositeMessage);
        Expr expr = (Expr)this.parameterStack.pop();
        Expr expr2 = BSWProtocol.compositeMessage((Expr)this.parameterStack.pop(), expr);
        Object e = this.parameterStack.pop();
        while (e != null) {
            expr2 = BSWProtocol.compositeMessage((Expr)e, expr2);
            e = this.parameterStack.pop();
        }
        if (this.parameterStack.isEmpty()) {
            this.appendFormula(expr2);
        } else {
            this.parameterStack.push(expr2);
        }
    }
}

