/*
 * Decompiled with CFR 0.152.
 */
import ie.ucc.cuc.daithi.BSW.logic.BSW;
import ie.ucc.cuc.daithi.BSW.logic.BSWProtocol;
import ie.ucc.cuc.daithi.BSW.verify.IntermediateFormatGenerator;
import ie.ucc.cuc.daithi.BSW.verify.TypeChecker;
import ie.ucc.cuc.daithi.BSW.verify.lexer.Lexer;
import ie.ucc.cuc.daithi.BSW.verify.node.Node;
import ie.ucc.cuc.daithi.BSW.verify.node.Start;
import ie.ucc.cuc.daithi.BSW.verify.parser.Parser;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PushbackReader;
import java.util.Enumeration;
import tc.Protocol;
import tc.Theory;
import tc.expr.Expr;

public class Verify {
    private Theory theory;
    private Protocol protocol;

    public Verify(BSW bSW, BSWProtocol bSWProtocol) {
        this.theory = new Theory(bSW, bSWProtocol.initialAssumptions());
        this.protocol = bSWProtocol;
    }

    public void verify() {
        this.theory.close();
        this.theory.theory();
        Enumeration enumeration = this.protocol.properties().elements();
        System.out.println("\n\nGoals -> ");
        int n = 1;
        while (enumeration.hasMoreElements()) {
            Expr expr = (Expr)enumeration.nextElement();
            System.out.print(" " + String.valueOf(n) + ") " + expr.toString() + ": ");
            System.out.println(this.theory.contains(expr) ? "Yes" : "No");
            ++n;
        }
        System.out.println();
    }

    public static void main(String[] stringArray) {
        System.out.print("\nBSW Verification Tool");
        if (stringArray.length != 1) {
            System.out.println("usage:");
            System.out.println("  java Verify filename");
            System.exit(1);
        }
        try {
            Lexer lexer = new Lexer(new PushbackReader(new BufferedReader(new FileReader(stringArray[0])), 1024));
            Parser parser = new Parser(lexer);
            Start start = parser.parse();
            TypeChecker typeChecker = new TypeChecker();
            ((Node)start).apply(typeChecker);
            IntermediateFormatGenerator intermediateFormatGenerator = new IntermediateFormatGenerator(typeChecker);
            ((Node)start).apply(intermediateFormatGenerator);
            BSWProtocol bSWProtocol = intermediateFormatGenerator.getProtocol();
            new Verify(new BSW(bSWProtocol), bSWProtocol).verify();
            System.out.println();
            return;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }
}

