/*
 * Decompiled with CFR 0.152.
 */
package tc.logic;

import com.objectspace.jgl.HashSet;
import com.objectspace.jgl.Set;
import java.util.Enumeration;
import tc.expr.Metric;
import tc.expr.Subst;
import tc.logic.Rule;
import tc.logic.TerminationNotProvedException;

public abstract class LRWLogic {
    protected Set shrinkingRules_ = new HashSet();
    protected Set growingRules_ = new HashSet();
    protected Set rewrites_ = new HashSet();

    protected abstract Rule[] sRules();

    protected abstract Rule[] gRules();

    protected abstract Rule[] rwRules();

    protected abstract Metric metric();

    public Set shrinkingRules() {
        return this.shrinkingRules_;
    }

    public Set growingRules() {
        return this.growingRules_;
    }

    public Set rewrites() {
        return this.rewrites_;
    }

    public LRWLogic() throws TerminationNotProvedException {
        Rule[] ruleArray = this.sRules();
        int n = 0;
        while (n < ruleArray.length) {
            this.shrinkingRules_.put(ruleArray[n]);
            ++n;
        }
        ruleArray = this.gRules();
        int n2 = 0;
        while (n2 < ruleArray.length) {
            this.growingRules_.put(ruleArray[n2]);
            ++n2;
        }
        ruleArray = this.rwRules();
        int n3 = 0;
        while (n3 < ruleArray.length) {
            this.rewrites_.put(ruleArray[n3]);
            ++n3;
        }
        this.checkRules();
    }

    public void checkRules() throws TerminationNotProvedException {
        this.checkSorG(this.shrinkingRules_, true);
        this.checkSorG(this.growingRules_, false);
        this.checkRewrites();
        this.checkSGRestriction();
    }

    protected void checkSorG(Set set, boolean bl) throws TerminationNotProvedException {
        Enumeration enumeration = set.elements();
        while (enumeration.hasMoreElements()) {
            Rule rule = (Rule)enumeration.nextElement();
            int n = this.metric().apply(rule.conclusion());
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < rule.numPremises() && !bl2) {
                bl2 = bl ? this.metric().apply(rule.premise(n2)) > n : this.metric().apply(rule.premise(n2)) < n;
                ++n2;
            }
            if (bl2) continue;
            throw new TerminationNotProvedException(rule);
        }
    }

    protected void checkRewrites() throws TerminationNotProvedException {
        Enumeration enumeration = this.rewrites_.elements();
        while (enumeration.hasMoreElements()) {
            Rule rule = (Rule)enumeration.nextElement();
            if (rule.numPremises() == 1 && this.metric().apply(rule.conclusion()) == this.metric().apply(rule.premise(0))) continue;
            throw new TerminationNotProvedException(rule);
        }
    }

    protected void checkSGRestriction() throws TerminationNotProvedException {
        Enumeration enumeration = this.shrinkingRules_.elements();
        HashSet hashSet = new HashSet();
        while (enumeration.hasMoreElements()) {
            Rule rule = (Rule)enumeration.nextElement();
            Enumeration enumeration2 = this.growingRules_.elements();
            while (enumeration2.hasMoreElements()) {
                Rule rule2 = (Rule)enumeration2.nextElement();
                int n = 0;
                while (n < rule.numPremises()) {
                    if (rule.premise(n).unify(rule2.conclusion(), new Subst()) != null) {
                        rule = rule.removePremise(n);
                        continue;
                    }
                    ++n;
                }
            }
            hashSet.put(rule);
        }
        this.checkSorG(hashSet, true);
    }
}

