/*
 * Decompiled with CFR 0.152.
 */
package tc.expr;

import java.util.Vector;
import tc.expr.Expr;
import tc.expr.Metric;
import tc.expr.Subst;
import tc.expr.Var;

public class Func
extends Expr {
    String name_;
    Vector args_;

    public Func(String string) {
        this.name_ = string;
        this.args_ = new Vector();
    }

    public Func(String string, Vector vector) {
        this.name_ = string;
        this.args_ = vector;
    }

    public Func(String string, Expr expr) {
        this(string);
        this.args_.addElement(expr);
    }

    public Func(String string, Expr expr, Expr expr2) {
        this(string, expr);
        this.args_.addElement(expr2);
    }

    public Func(String string, Expr expr, Expr expr2, Expr expr3) {
        this(string, expr, expr2);
        this.args_.addElement(expr3);
    }

    public Func(String string, Expr expr, Expr expr2, Expr expr3, Expr expr4) {
        this(string, expr, expr2, expr3);
        this.args_.addElement(expr4);
    }

    public Subst match(Expr expr, Subst subst) {
        if (expr instanceof Func) {
            Func func = (Func)expr;
            if (this.name_.equals(func.name_) && this.arity() == func.arity()) {
                Subst subst2 = subst;
                int n = 0;
                while (subst2 != null && n < this.args_.size()) {
                    subst2 = this.getArg(n).match(func.getArg(n), subst2);
                    ++n;
                }
                return subst2;
            }
            return null;
        }
        return null;
    }

    public Subst unify(Expr expr, Subst subst) {
        if (expr instanceof Var) {
            return expr.unify(this, subst);
        }
        Func func = (Func)expr;
        if (!this.name_.equals(func.name_) || this.arity() != func.arity()) {
            return null;
        }
        Subst subst2 = subst;
        int n = 0;
        while (subst2 != null && n < this.args_.size()) {
            subst2 = this.getArg(n).unify(func.getArg(n), subst2);
            ++n;
        }
        return subst2;
    }

    public Vector vars() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.args_.size()) {
            Expr expr = (Expr)this.args_.elementAt(n);
            Vector vector2 = expr.vars();
            int n2 = 0;
            while (n2 < vector2.size()) {
                vector.addElement(vector2.elementAt(n2));
                ++n2;
            }
            ++n;
        }
        return vector;
    }

    public boolean hasVar(Var var) {
        boolean bl = false;
        int n = 0;
        while (!bl && n < this.args_.size()) {
            Expr expr = (Expr)this.args_.elementAt(n);
            bl = bl || expr.hasVar(var);
            ++n;
        }
        return bl;
    }

    public boolean equals(Func func) {
        boolean bl = this.name_.equals(func.name_) && this.args_.size() == func.args_.size();
        int n = 0;
        while (bl && n < this.args_.size()) {
            Expr expr = (Expr)this.args_.elementAt(n);
            Expr expr2 = (Expr)func.args_.elementAt(n);
            bl = bl && expr.equals(expr2);
            ++n;
        }
        return bl;
    }

    public boolean equals(Object object) {
        return object instanceof Func && this.equals((Func)object);
    }

    public Expr applySubst(Subst subst) {
        if (subst.retrieve(this) != null) {
            return subst.retrieve(this);
        }
        if (this.args_.size() == 0) {
            return this;
        }
        Vector<Expr> vector = new Vector<Expr>();
        int n = 0;
        while (n < this.args_.size()) {
            vector.addElement(this.getArg(n).applySubst(subst));
            ++n;
        }
        return new Func(this.name_, vector);
    }

    public Subst newVarMap(Subst subst) {
        Subst subst2 = subst;
        int n = 0;
        while (n < this.args_.size()) {
            Expr expr = (Expr)this.args_.elementAt(n);
            subst2 = expr.newVarMap(subst2);
            ++n;
        }
        return subst2;
    }

    public String toString() {
        String string = this.name_;
        if (this.args_.size() > 0) {
            string = string + "(" + this.getArg(0).toString();
            int n = 1;
            while (n < this.args_.size()) {
                string = string + ", " + this.getArg(n).toString();
                ++n;
            }
            string = string + ")";
        }
        return string;
    }

    public String name() {
        return this.name_;
    }

    public Expr getArg(int n) {
        return (Expr)this.args_.elementAt(n);
    }

    public int hashCode() {
        int n = 1;
        int n2 = 0;
        while (n2 < this.args_.size()) {
            n *= this.args_.elementAt(n2).hashCode();
            ++n2;
        }
        return n += this.name_.hashCode();
    }

    public int arity() {
        return this.args_.size();
    }

    public int computeMetric(Metric metric) {
        return metric.apply(this);
    }
}

