/*
 * Decompiled with CFR 0.152.
 */
package tc;

import com.objectspace.jgl.HashSet;
import java.util.Enumeration;
import tc.Protocol;
import tc.Theory;
import tc.expr.Expr;
import tc.logic.Logic;

public class TheoryChecker {
    private Theory Th;
    private Protocol proto;

    public TheoryChecker(Logic logic, Protocol protocol) {
        this.Th = new Theory(logic, protocol.initialAssumptions());
        this.proto = protocol;
    }

    public void run() {
        long l = System.currentTimeMillis();
        this.Th.close();
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        HashSet hashSet = this.Th.theory();
        System.out.println("Generated Theory in " + l3 + " ms");
        System.out.println("Theory contains " + hashSet.size() + " formulae, of which " + this.proto.initialAssumptions().size() + " were initial assumptions");
        System.out.println("Formulae in theory for " + this.proto.toString() + ":\n\n");
        Enumeration enumeration = hashSet.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement().toString() + "\n");
        }
        enumeration = this.proto.properties().elements();
        System.out.println("Desired properties for protocol " + this.proto.toString() + ":");
        int n = 1;
        while (enumeration.hasMoreElements()) {
            Expr expr = (Expr)enumeration.nextElement();
            System.out.print(String.valueOf(n) + ") " + expr.toString() + ": ");
            if (this.Th.contains(expr)) {
                System.out.println("Yes");
            } else {
                System.out.println("No");
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        TheoryChecker theoryChecker = new TheoryChecker((Logic)Class.forName(stringArray[0]).newInstance(), (Protocol)Class.forName(stringArray[1]).newInstance());
        theoryChecker.run();
    }
}

