/*
 * Decompiled with CFR 0.152.
 */
package tc;

import com.objectspace.jgl.HashSet;
import java.util.Enumeration;
import java.util.Vector;
import tc.Message;
import tc.RVProtocol;
import tc.Theory;
import tc.expr.Expr;
import tc.logic.RV;
import tc.logic.Rule;

public class RVChecker {
    private RV rv = new RV();
    private Theory th;
    private RVProtocol proto;
    private Message m;

    public RVChecker(RVProtocol rVProtocol) throws Exception {
        this.proto = rVProtocol;
        this.rv.interpret(rVProtocol);
        this.th = new Theory(this.rv, rVProtocol.assumptions());
    }

    public void run() {
        System.out.println("RVChecker analyzing protocol " + this.proto);
        this.printAssumptions();
        this.printInterpretation();
        System.out.print("\nGenerating initial Theory...");
        this.th.close();
        Vector vector = this.proto.messages();
        int n = 0;
        while (n < vector.size()) {
            this.m = (Message)vector.elementAt(n);
            System.out.println("\nMessage " + (n + 1) + ": " + this.m.sender + " -> " + this.m.recipient + ": " + this.m.message);
            System.out.print("Generating consequence closure...");
            HashSet hashSet = new HashSet();
            hashSet.put(RV.sees(this.m.recipient, this.m.message));
            this.th.closeOver(hashSet);
            this.checkFeasibility();
            this.checkHonesty();
            this.checkSecrecy();
            ++n;
        }
        this.checkGoals();
        System.out.println("Final Theory Size: " + this.th.theory().size());
    }

    void printAssumptions() {
        Enumeration enumeration = this.proto.assumptions().elements();
        System.out.println("\nProtocol Assumptions");
        System.out.println("====================");
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
    }

    void printInterpretation() {
        System.out.println("\nProtocol Interpretation Rules");
        System.out.println("=============================");
        Enumeration enumeration = this.proto.interpretation().elements();
        while (enumeration.hasMoreElements()) {
            this.printRule((Rule)enumeration.nextElement());
        }
    }

    void printRule(Rule rule) {
        Enumeration enumeration = rule.premises();
        int n = 1;
        System.out.println();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            System.out.println(string);
            if (string.length() <= n) continue;
            n = string.length();
        }
        int n2 = 0;
        while (n2 < n) {
            System.out.print("-");
            ++n2;
        }
        System.out.println("\n" + rule.conclusion());
    }

    void printTheory() {
        HashSet hashSet = this.th.theory();
        Enumeration enumeration = hashSet.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            System.out.println(e);
        }
    }

    public void checkFeasibility() {
        if (this.th.contains(RV.canProduce(this.m.sender, this.m.message))) {
            System.out.print("\nMessage " + this.m.number + " passes feasibility check.");
        } else {
            System.out.print("\nMessage " + this.m.number + " fails feasibility check!");
        }
    }

    public void checkHonesty() {
        if (this.th.contains(RV.believes(this.m.sender, RV.legit(this.m.message)))) {
            System.out.print("\nMessage " + this.m.number + " passes honesty check.");
        } else {
            System.out.print("\nMessage " + this.m.number + " fails honesty check!");
        }
    }

    public void checkSecrecy() {
        if (this.th.contains(RV.believes(this.m.sender, RV.maysee(RV.I(), this.m.message)))) {
            System.out.print("\nMessage " + this.m.number + " passes secrecy check.");
        } else {
            System.out.print("\nMessage " + this.m.number + " fails secrecy check!");
        }
    }

    public void checkGoals() {
        System.out.println("\n\nProtocol Goals:");
        System.out.println("===============");
        Enumeration enumeration = this.proto.properties().elements();
        int n = 1;
        while (enumeration.hasMoreElements()) {
            Expr expr = (Expr)enumeration.nextElement();
            System.out.print(n++ + ". ");
            System.out.println(expr + ": " + this.th.contains(expr));
        }
    }

    public static void main(String[] stringArray) throws Exception {
        RVChecker rVChecker = new RVChecker((RVProtocol)Class.forName("tc.protocols." + stringArray[0]).newInstance());
        rVChecker.run();
    }
}

