/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.algorithms;

import com.objectspace.jgl.BidirectionalIterator;
import com.objectspace.jgl.Container;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.algorithms.Swapping;
import java.util.Random;

public final class Shuffling {
    static Random randgen = new Random();

    private Shuffling() {
    }

    public static void randomShuffle(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2, Random random) {
        if (!bidirectionalIterator.isCompatibleWith(bidirectionalIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        if (!(bidirectionalIterator.getContainer() instanceof Sequence)) {
            throw new IllegalArgumentException("iterator containers must be a Sequence");
        }
        BidirectionalIterator bidirectionalIterator3 = (BidirectionalIterator)bidirectionalIterator.clone();
        if (bidirectionalIterator3.equals(bidirectionalIterator2)) {
            return;
        }
        bidirectionalIterator3.advance();
        int n = 2;
        while (!bidirectionalIterator3.equals(bidirectionalIterator2)) {
            BidirectionalIterator bidirectionalIterator4 = (BidirectionalIterator)bidirectionalIterator.clone();
            bidirectionalIterator4.advance(Math.abs(random.nextInt()) % n);
            Swapping.iterSwap(bidirectionalIterator3, bidirectionalIterator4);
            bidirectionalIterator3.advance();
            ++n;
        }
    }

    public static void randomShuffle(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2) {
        Shuffling.randomShuffle(bidirectionalIterator, bidirectionalIterator2, randgen);
    }

    public static void randomShuffle(Container container, Random random) {
        Shuffling.randomShuffle((BidirectionalIterator)container.start(), (BidirectionalIterator)container.finish(), random);
    }

    public static void randomShuffle(Container container) {
        Random random = randgen;
        Shuffling.randomShuffle((BidirectionalIterator)container.start(), (BidirectionalIterator)container.finish(), random);
    }
}

