/**
 * A class that represents highly emotional 
 * objects.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class Wreck
{
   /**
    * Displays a greeting on the standard 
    * output.
    */
   public void displayGreeting()
   {  previousUtterance = "Hi. I'm a gibbering wreck.";
      System.out.println("Hi. I'm a gibbering wreck.");
   }

   /**
    * Returns a greeting from this wreck.
    *
    * @return a string containing a greeting.
    */
   public String getGreeting()
   {  previousUtterance = "Hi. I'm a gibbering wreck.";
      return "Hi. I'm a gibbering wreck.";
   }

   /**
    * Displays two random syllables on the 
    * standard output. Each syllable comprises 
    * a random consonant-vowel pair.
    */
   public void displayGibberish()
   {  /* Set up vowel & consonant lists.
       */
      String consonants = "bcdfghjklmnpqrstvwxyz"; // Roman alphabet consonants
      String vowels = "aeiou"; // Roman alphabet vowels

      /* Generate a random number and use it 
         to select a consonant.
       */
      int r1 = (int) (Math.random() * consonants.length());
      String randomConsonant = consonants.substring(r1, r1 + 1); // the r1th 
                                                                // letter

      /* Generate a random number and use it 
         to select a vowel.
       */
      int r2 = (int) (Math.random() * vowels.length()); 
      String randomVowel = vowels.substring(r2, r2 + 1); // the r2th letter

      /* Form the syllable from the consonant 
         and the vowel and display it twice.
       */
      String syllable = randomConsonant + randomVowel;
      previousUtterance = syllable + syllable;
      System.out.println(syllable + syllable);
   }

   /**
    * Returns a copy of the parameter
    * concatenated to itself.
    *
    * @param aMessage a string that will be 
    * mimicked.
    * @return the parameter concatenated to
    * an uppercase version of itself.
    */
   public String getMimicry(String aMessage)
   {  String messageInUpperCase = aMessage.toUpperCase();
      previousUtterance = aMessage + messageInUpperCase;
      return aMessage + messageInUpperCase;
   }

   /**
    * Returns whatever the wreck said
    * in whatever method it executed
    * previous to this one.
    *
    * @return a repetition of whatever
    * this wreck said previously.
    */
   public String getRepetition()
   {  return previousUtterance;
   }

   /**
    * The previous utterance of this wreck.
    */
   private String previousUtterance = "I ain't said nothing yet.";
}