import java.util.*;

/**
 * A class that represents CDs.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class CD
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new CD.
    *
    * @param theArtist the recording artist; must be non-null & non-empty.
    * @param theTitle the CD title; must be non-null & non-empty.
    * @param thePrice the CD price; must be greater than zero.
    */
   public CD(String theArtist, String theTitle, int thePrice)
   {  idNum = PREFIX + nextIdNum;
      nextIdNum++;
      artist = theArtist;
      title = theTitle;
      price = thePrice;
      tracks = new Vector();
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the identification number of this CD.
    *
    * @return the identification number.
    */
   public String getIdNum()
   {  return idNum;
   }

   /**
    * Returns the CD's artist.
    *
    * @return the artist.
    */
   public String getArtist()
   {  return artist;
   }

   /**
    * Returns the CD's title.
    *
    * @return the title.
    */
   public String getTitle()
   {  return title;
   }

   /**
    * Returns the price of this CD.
    *
    * @return the price of this CD.
    */
   public int getPrice()
   {  return price;
   }

   /**
    * Returns the CD's tracks.
    *
    * @return the CD's tracks.
    */
   public Vector getTracks()
   {  return tracks;
   }
   
/* --Setters----------------------------------------------------------- */

   /**
    * Sets the CD artist to the specified value.
    *
    * @param theArtist the revised artist; must be non-null & non-empty.
    */
   public void setArtist(String theArtist)
   {  artist = theArtist;
   }

   /**
    * Sets the CD title to the specified value.
    *
    * @param theTitle the revised title; must be non-null & non-empty.
    */
   public void setTitle(String theTitle)
   {  title = theTitle;
   }

   /**
    * Sets the CD price to the specified value.
    *
    * @param thePrice the revised price; must be greater than zero.
    */
   public void setPrice(int thePrice)
   {  price = thePrice;
   }

   /**
    * Adds a track to the CD.
    *
    * @param thetrack the new track; must be non-null.
    */
   public void addTrack(String theTrack)
   {  tracks.add(theTrack);
   }

   /**
    * Remove the specified track from the CD.
    *
    * @param theTrack the track to be removed; must be non-null & must be an
    * track that is on the CD.
    */
   public void removeTrack(String theTrack)
   {  tracks.remove(theTrack);
   }

/* --Common object interface------------------------------------------- */

   /**
    * Returns a string representation of this CD.
    *
    * @return a string representation of this CD.
    */
   public String toString()
   {  return idNum + " " + artist + ": " + title + ". Price: " + price;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The CD's unique identification code (a prefix and a number).
    */
   private String idNum;

   /**
    * The CD's artist(s).
    */
   private String artist;

   /**
    * The title of the CD.
    */
   private String title;

   /**
    * The price of the CD in pennies.
    */
   private int price;

   /**
    * A list of the tracks on the CD (each track is a string,
    * i.e. simply its title).
    */
   private Vector tracks;

   /**
    * The identification number to use for the next new CD.
    */
   private static int nextIdNum = 5555;

   /**
    * Identification codes comprise this prefix and a unique integer.
    */
   private static final String PREFIX = "CD";
}
