import java.util.*;

/**
 * A class that represents collections of Orders.
 * The way this class is implemented at the moment is to store CD
 * objects in a Vector. (Vectors are used because they tie in
 * with Swing JLists.) Better would be if this class were implemented
 * to mediate between the program proper and a random-access file or
 * a database. That way data, and changes to the data, would be
 * persistent, i.e. would not be lost between runs of the program.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class OrderCollection
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new, empty collection of Orders.
    */
   public OrderCollection()
   {  orders = new Vector();
   }

   /** 
    * Allocates a new collection of orders based on an existing
    * Vector of orders.
    *
    * @param theOrders the Vector of orders that initialises this
    * collection.
    */
   public OrderCollection(Vector theOrders)
   {  orders = theOrders;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns all orders in the collection.
    */
   public Vector findAll()
   {  return orders;
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Add the specified Order object to the collection.
    *
    * @param theOrder the Order being added to the collection; must be 
    * non-null & not already in the collection.
    */
   public void add(Order theOrder)
   {  orders.add(theOrder);
   }

   /**
    * Remove the specified Order from the collection.
    *
    * @param theOrder the Order to be removed; must be non-null and
    * an Order already in the collection.
    */
   public void remove(Order theOrder)
   {  orders.remove(theOrder);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The orders in the collection.
    */
   private Vector orders;
}
