import java.io.*;

/**
 * A class that represents objects that can copy files.
 * @author Derek Bridge
 */
public class FileCopier
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new file copier object to copy the specified source
    * file to the specified target file.
    *
    * @param theSource the file to be copied.
    * @param theTarget the file to copy to.
    */
   public FileCopier(File theSource, File theTarget)
   {  source = theSource;
      target = theTarget;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

   /**
    * Copies bytes from source file to target file.
    */
   public void copy() throws FileNotExistException,
      FileExistsException, IOException
   {  FileInputStream fis = null;
      FileOutputStream fos = null;
      int nextByte = 0;
      boolean eof = false;
      if (! source.exists())
      {  throw new FileNotExistException();
      }
      fis = new FileInputStream(source);
      if (target.exists())
      {  throw new FileExistsException();
      }
      fis = new FileInputStream(source);
      fos = new FileOutputStream(target);
      do
      {  nextByte = fis.read();
         eof = (nextByte == -1);
         if (! eof)
         {  fos.write(nextByte);
         }
      } while (! eof);
      fis.close();
      fos.close();
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   /**
    * Source file (copied from).
    */
   private File source;

   /**
    * Target file (copied to).
    */
   private File target;

/* =======================================================================
       TEST DRIVER
   =======================================================================
*/
   public static void main(String[] args)
      throws FileNotExistException, FileExistsException, IOException
   {  FileCopier copier = new FileCopier(
         new File("original.txt"), new File("copy.txt"));
      copier.copy();
   }
}
