import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A class that demonstrates the Timer class.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class TimerLabel
   extends JLabel
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new animated label object.
    */
   public TimerLabel()
   {  super();
      timer = new Timer(1000, 
         new ActionListener()
         {  public void actionPerformed(ActionEvent ae)
            {  frameNumber++;
               setText("" + frameNumber);
            }
         });
   }


/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/
   /**
    * Starts the time that controls the animation.
    */
   public synchronized void startAnimation()
   {  timer.start();
   }

   /**
    * Stops the timer that controls the animation.
    */
   public synchronized void stopAnimation()
   {  timer.stop();
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The timer that controls the animation.
    */
   private Timer timer;

   /**
    * Keeps track of the number being displayed.
    */
   private int frameNumber = -1;

/* =======================================================================
       TEST DRIVER
   =======================================================================
*/
  
   public static void main(String[] args)
   {  JFrame frame = new JFrame("Timer Demo");
      final TimerLabel lbl = new TimerLabel();
      Container contentPane = frame.getContentPane();
      contentPane.add(lbl);
      frame.addWindowListener(new WindowAdapter()
      {  public void windowClosing(WindowEvent we)
         {  System.exit(0);
         }
      });
      frame.pack();
      frame.setVisible(true);
      lbl.startAnimation();
   }
}
