import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A class that represents numeric keypads.
 * (This one illustrates layout using gridbag layout.)
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class NumericPad6
   extends JPanel
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new numeric keypad.
    *
    */
   public NumericPad6()
   {  super();

      digitB = new JButton[10];
      for (int i = 0; i < 10; i++)
      {  digitB[i] = new JButton("" + i);
      }
      enterB = new JButton("Enter");

      GridBagLayout gbl = new GridBagLayout();
      GridBagConstraints gbc = new GridBagConstraints();
      setLayout(gbl);
      
      gbc.fill = GridBagConstraints.BOTH;
      gbc.anchor = GridBagConstraints.CENTER;

      addComp(digitB[0], this, gbl, gbc, 0, 0, 1, 3, 1, 1);

      for (int i = 1; i < 10; i++)
      {  addComp(digitB[i], this, gbl, gbc, (i + 2) / 3, 
            (i % 3) - 1, 1, 1, 1, 1);
      }

      addComp(enterB, this, gbl, gbc, 0, 3, 4, 1, 1, 1);
   }

/* =======================================================================
       HELPER METHODS
   =======================================================================
*/
   /**
    * Utility method for adding components to a container using
    * grid bag layout constraints.
    *
    * @param comp the component being added.
    * @param cont the container we're adding to.
    * @param gbl the layout manager.
    * @param gbc the layout manager's constraints object.
    * @param row the row we're positioning in.
    * @param col the column we're positioning in.
    * @param numRows the number of rows this component is to span.
    * @param numCols the number of columns this component is to span.
    * @param weightx horizontal resize weight.
    * @param weighty vertical resize weight.
    */
   private void addComp(Component comp, Container cont, GridBagLayout gbl,
      GridBagConstraints gbc, int row, int col, int numRows, int numCols,
      double weightx, double weighty)
   {  gbc.gridx = col;
      gbc.gridy = row;
      gbc.gridwidth = numCols;
      gbc.gridheight = numRows;
      gbc.weightx = weightx;
      gbc.weighty = weighty;

      cont.add(comp, gbc);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   /**
    * Array of digit buttons.
    */
   private JButton[] digitB;

   /**
    * The Enter button.
    */
   private JButton enterB;

/* =======================================================================
       TEST DRIVER
   =======================================================================
*/
   public static void main(String[] args)
   {  NumericPad6 pad = new NumericPad6();
      JFrame frm = new JFrame("Gridbag layout");
      frm.addWindowListener(new WindowAdapter()
      {  public void windowClosing(WindowEvent we)
         {  System.exit(0);
         }
      });
      Container contentPane = frm.getContentPane();
      contentPane.add(pad);
      frm.pack();
      frm.setVisible(true);
   }
}
