import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A class that represents numeric keypads.
 * (This one illustrates layout using absolute sizes and positions.)
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class NumericPad2
   extends JPanel
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new numeric keypad.
    *
    */
   public NumericPad2()
   {  super();
   
      digitB = new JButton[10];
      for (int i = 0; i < 10; i++)
      {  digitB[i] = new JButton("" + i);
      }
      enterB = new JButton("Enter");

      setLayout(null);

      digitB[0].setBounds(X_MARGIN, Y_MARGIN, TREBLE_SIZE, NORMAL_SIZE);
      add(digitB[0]);

      for (int i = 1; i < 10; i++)
      {  digitB[i].setBounds(X_MARGIN + NORMAL_SIZE * ((i - 1) % 3),
            Y_MARGIN + NORMAL_SIZE + NORMAL_SIZE * ((i - 1) / 3),
            NORMAL_SIZE, NORMAL_SIZE);
         add(digitB[i]);
      }

      enterB.setBounds(X_MARGIN + 3 * NORMAL_SIZE, Y_MARGIN,
         NORMAL_SIZE, QUADRUPLE_SIZE);
      add(enterB);
   }


/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * Array of digit buttons.
    */
   private JButton[] digitB;

   /**
    * The Enter button.
    */
   private JButton enterB;

   /**
    * The width & height of digit buttons.
    */
   private static final int NORMAL_SIZE = 80;

   /**
    * The length of the zero button.
    */
   private static final int TREBLE_SIZE = NORMAL_SIZE * 3;

   /**
    * The height of the Enter button.
    */
   private static final int QUADRUPLE_SIZE = NORMAL_SIZE * 4;

   /**
    * How far in the pad should start.
    */
   private static final int X_MARGIN = 20;

   /**
    * How far down the pad should start.
    */
   private static final int Y_MARGIN = 20;

/* =======================================================================
       TEST DRIVER
   =======================================================================
*/

   public static void main(String[] args)
   {  NumericPad2 pad = new NumericPad2();
      JFrame frm = new JFrame("Absolute Sizes and Positions (Calculated)");
      frm.addWindowListener(new WindowAdapter()
      {  public void windowClosing(WindowEvent we)
         {  System.exit(0);
         }
      });
      Container contentPane = frm.getContentPane();
      contentPane.add(pad);
      frm.setBounds(100, 100, X_MARGIN * 2 + QUADRUPLE_SIZE + 40, 
          Y_MARGIN * 2 + QUADRUPLE_SIZE + 40);
      frm.setVisible(true);
   }
}
