import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A class that represents a GUI to a temperature conversion program.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class TempConversionGUI
   extends JPanel
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new panel that displays Fahrenheit and corresponding
    * centigrade temperatures and offers button for requesting conversion
    * between the two.
    */
   public TempConversionGUI()
   {  super();
      fahrLabel = new JLabel(DEGREES_FAHRENHEIT);
      fahrField = new JTextField(INIT_FAHR, TFCOLS);
      centLabel = new JLabel(DEGREES_CENTIGRADE);
      centField = new JTextField(INIT_CENT, TFCOLS);
      compFahrBtn = new JButton(COMPUTE_FAHRENHEIT);
      compCentBtn = new JButton(COMPUTE_CENTIGRADE);

      add(fahrLabel);
      add(fahrField);
      add(centLabel);
      add(centField);
      add(compFahrBtn);
      add(compCentBtn);

      compFahrBtn.addActionListener(
         new CompFahrBtnLstnr(this));

      compCentBtn.addActionListener(
         new CompCentBtnLstnr(this));
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Public class constants-------------------------------------------- */

   /**
    * A label that goes alongside the Fahrenheit temperature textfield.
    */
   public static final String 
      DEGREES_FAHRENHEIT = "Degrees Fahrenheit"; 

   /**
    * A label that goes alongside the centigrade temperature textfield.
    */
   public static final String
      DEGREES_CENTIGRADE = "Degrees Centigrade"; // textfield label

   /**
    * Text that goes onto the button that requests centigrade to
    * Fahrenheit conversion.
    */
   public static final String 
      COMPUTE_FAHRENHEIT = "Compute Fahrenheit"; // button text

   /**
    * Text that goes onto the button that requests centigrade to
    * Fahrenheit conversion.
    */
   public static final String
      COMPUTE_CENTIGRADE = "Compute Centigrade"; // button text

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the current value in the Fahrenheit textfield as an int.
    *
    * @param the current value in the Fahrenheit textfield, converted to
    * an int.
    */
   public int getFahrField()
   {  String str = fahrField.getText().trim();
      return Integer.parseInt(str);
   }

   /**
    * Returns the current value in the centigrade textfield as an int.
    *
    * @param the current value in the centigrade textfield, converted to
    * an int.
    */
   public int getCentField()
   {  String str = centField.getText().trim();
      return Integer.parseInt(str);
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Updates the value in the Fahrenheit textfield.
    *
    * @param theFahr the new Fahrenheit value.
    */
   public void setFahrField(int theFahr)
   {  fahrField.setText("" + theFahr);
   }

   /**
    * Updates the value in the centigrade textfield.
    *
    * @param theCent the new centigrade value.
    */
   public void setCentField(int theCent)
   {  centField.setText("" + theCent);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /** 
    * The label that goes alongside the Fahrenheit temperature textfield.
    */
   private JLabel fahrLabel;

   /** 
    * The Fahrenheit temperature textfield.
    */
   private JTextField fahrField;

   /** 
    * The label that goes alongside the Fahrenheit temperature textfield.
    */
   private JLabel centLabel;

   /** 
    * The centigrade temperature textfield.
    */
   private JTextField centField;

   /**
    * The button for requesting centigrade to Fahrenheit conversion.
    */
   private JButton compFahrBtn;

   /**
    * The button for requesting Fahrenheit to centigrade conversion.
    */
   private JButton compCentBtn;

   /**
    * Initial Fahrenheit textfield value (212 F = 100 C)
    */
   private static final String 
      INIT_FAHR = "212"; 

   /**
    * Initial centigrade textfield value (100 C = 212F)
    */
   private static final String 
      INIT_CENT = "100"; 

   /**
    * The width of the textfields (in columns).
    */
   private static final int TFCOLS = 6;

/* =======================================================================
       TEST DRIVER
   =======================================================================
*/
   public static void main(String[] args)
   {  TempConversionGUI gui = new TempConversionGUI();
      JFrame frm = new JFrame("Temperature Conversions");
      Container contentPane = frm.getContentPane();
      contentPane.add(gui);
      frm.addWindowListener(new WindowAdapter()
      { public void windowClosing(WindowEvent we)
        {  System.exit(0);
        }
      });
      frm.setBounds(50, 75, 250, 150);
      frm.setVisible(true);
   }
}