import java.awt.event.*;

/**
 * A class that represents objects that convert Fahrenheit temperatures
 * to centigrade temperatures in response to button clicks.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class CompCentBtnLstnr
   implements ActionListener
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new listener object for converting Fahrenheit temperatures
    * to centigrade temperatures in response to button clicks.
    *
    * @param theGUI the temperature conversion GUI on which the button is
    * located.
    */
   public CompCentBtnLstnr(TempConversionGUI theGUI)
   {  gui = theGUI;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/
   /**
    * Gets a Fahrenheit temperature from a GUI, converts it to
    * centigrade and informs the GUI of the new value.
    * Invoked in response to button clicks.
    *
    * @param ae the button click event.
    */
   public void actionPerformed(ActionEvent ae)
   {  int fahr = gui.getFahrField();
      int cent = (int) Math.round((fahr - 32) * 5.0 / 9.0);
      gui.setCentField(cent);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * A reference to the gui on which the button for which this is
    * a listener resides.
    */
   private TempConversionGUI gui;
}