import java.util.*;

/**
 * A program that exploits an interface that `cuts across a class
 * hierarchy'.
 * This version uses the interface to retain the natural class
 * hierarchy and yet still cope with the need for casting.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class PayAsYouGo
{
   public static void main(String[] args)
   {  Set assets = new HashSet();
      assets.add(new Shop(100, 250, "The Shopping Centre"));
      assets.add(new CompanyCar(12000, 5000, "CAR1"));
      assets.add(new Shop(340, 250, "The High Street"));
      assets.add(new Photocopier());
      assets.add(new PC(560, 3));
      assets.add(new Warehouse(10000, 40, "The Industrial Estate"));

      double totalAssetValue = 0;
      Iterator iter = assets.iterator();
      while (iter.hasNext())
      {  ITaxable asset = 
            (ITaxable) iter.next();
         totalAssetValue += 
                  asset.getTaxableValue();
      }
   }
}