/**
 * A class that represents a company's PC assets.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class PC 
   extends OfficeEquipment
{  
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new company PC object.
    *
    * @param thePurchasePrice the amount the PC cost.
    * @param theAge the age of the PC.
    */
   public PC(double thePurchasePrice, int theAge)
   {  super();
      purchasePrice = thePurchasePrice;
      age = theAge;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the taxable value of this PC.
    *
    * @return the taxable value of this PC.
    */
   public double getTaxableValue()
   {  return purchasePrice / age;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The amount the PC cost.
    */
   protected double purchasePrice;
   
   /**
    * The age of the PC.
    */
   protected int age;
}