/**
 * A class that represents a company's building assets.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class Building 
   implements ITaxable
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new company building object.
    * 
    * @param theFloorSpace the floor area of the building.
    * @param theLandRate the value of the land per square metre.
    * @param theAddress the building's postal address.
    */
   public Building(double theFloorSpace, double theLandRate, 
      String theAddress)
   {  floorSpace = theFloorSpace;
      landRate = theLandRate;
      address = theAddress;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the taxable value of this building.
    *
    * @return the taxable value of this building.
    */
   public double getTaxableValue()
   {  return floorSpace * landRate;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The floor area of the building.
    */
   protected double floorSpace;

   /**
    * The value of the land per square metre.
    */
   protected double landRate;
 
   /**
    * The building's postal address.
    */
   protected String address;
}