/**
 * A class that represents a company's vehicles.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class Vehicle 
   extends TaxableThing
{  
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new company car object.
    * 
    * @param thePurchasePrice the price the car cost.
    * @param theDepreciation the rate at which the car's value declines.
    * @param theRegistrationNum the car's registration number.
    */
   public Vehicle(double thePurchasePrice, double theDepreciation, 
      String theRegistrationNum)
   {  purchasePrice = thePurchasePrice;
      depreciation = theDepreciation;
      registrationNum = theRegistrationNum;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the taxable value of this building.
    *
    * @return the taxable value of this building.
    */
   public double getTaxableValue()
   {  return purchasePrice - depreciation;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The purchase price of the vehicle.
    */
   protected double purchasePrice;

   /**
    * The rate at which the vehicle's value declines.
    */
   protected double depreciation;

   /**
    * The vehicle's registration number.
    */
   protected String registrationNum;
}