/**
 * A class that represents objects that are in the inventory
 * of a camera shop.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public abstract class InventoryItem
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new inventory item.
    *
    * @param aDescription describes the inventory item.
    * @param anInventoryNumber identifies the item.
    * @param theQuantityOnHand how many there are in the store.
    * @param thePrice how much each one costs.
    */
   public InventoryItem(String aDescription, int anInventoryNumber, 
      int theQuantityOnHand, int thePrice)
   {  description = aDescription;
      inventoryNumber = anInventoryNumber;
      quantityOnHand = theQuantityOnHand;
      price = thePrice;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Displays details of this item on the screen.
    */
   public abstract void display();

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   /**
    * Description of the inventoy item.
    */
   protected String description;

   /**
    * Identification number.
    */
   protected int inventoryNumber;

   /**
    * The number we have in stock.
    */
   protected int quantityOnHand;

   /**
    * The price per item.
    */
   protected int price;
}

