/**
 * A class that represents cameras that are in the inventory
 * of a camera shop.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class Camera 
   extends InventoryItem
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new inventory item.
    *
    * @param aDescription describes the inventoy item.
    * @param anInventoryNumber identifies the item.
    * @param theQuantityOnHand how many there are in the store.
    * @param thePrice how much each one costs.
    * @param theHasLens whether this camera comes with a lens.
    * @param theMaxShutterSpeed the maximum shutter speed of this model.
    * @param theBodyColour the colour of the camera.
    */
   public Camera(String aDescription, int anInventoryNumber, 
      int theQuantityOnHand, int thePrice, boolean theHasLens,
      int theMaxShutterSpeed, String theBodyColour)
   {  super(aDescription, anInventoryNumber, theQuantityOnHand, thePrice);
      hasLens = theHasLens;
      maxShutterSpeed = theMaxShutterSpeed;
      bodyColour = theBodyColour;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Displays details of this camera on the screen.
    */
   public void display()
   {  System.out.println("Camera " + inventoryNumber +
         quantityOnHand + " " + bodyColour);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   /**
    * Whether the camera comes with a lens.
    */
   protected boolean hasLens;

   /**
    * The maximum shutter speed of this model of camera.
    */
   protected int maxShutterSpeed;

   /**
    * The colour of the body of the camera.
    */
   protected String bodyColour;
}