/**
 * A class that represents an academic's publications in conference
 * proceedings.
 * @author Derek Bridge
 */
public class ConferencePaper
   extends Publication
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new conference paper object.
    *
    * @param the paper's title.
    * @param the name of the paper's author.
    * @param the year the paper was published.
    * @param the conference in which it was published.
    * @param the page it on which it starts in the printed volume.
    * @param the page on which is ends in the printed volume.
    */
   public ConferencePaper(String theTitle, PersonName theAuthor,
      int theYearOfPub, String theConfName, int theStartPage, int theEndPage)
   {  super(theTitle, theAuthor, theYearOfPub);
      confName = theConfName;
      startPage = theStartPage;
      endPage = theEndPage;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the length of the paper in pages.
    *
    * @return the length of the paper in pages.
    */
   public int getLength()
   {  return endPage - startPage + 1;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   /**
    * The conference in which the paper was published.
    */
   private String confName;

   /**
    * The page on which the paper starts in the printed volume.
    */
   private int startPage;

   /**
    * The page on which the paper ends in the printed volume.
    */
   private int endPage;

/* =======================================================================
       TEST DRIVER
   =======================================================================
*/
   public static void main(String[] args)
   {  ConferencePaper cp = new ConferencePaper(
         "Defining and Combining Symmetric and Asymmetric Similarity Measures",
         new PersonName("Dr.", "Derek", "Bridge"),
         1998,
         "Fourth European Workshop on Case-Based Reasoning",
         52, 63);

      System.out.println(cp.getTitle());
      cp.setTitle("Useless waffle");
      System.out.println(cp.getTitle());
      System.out.println(cp.getLength());      
   }
}
