/**
 * A class that represents people's names.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class PersonName
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new PersonName object with
    * the given title, forename and surname.
    *
    * @param aTitle the title in this name.
    * @param aForename the forename in this 
    * name.
    * @param aSurname the surname in this 
    * name.
    */
   public PersonName(String aTitle, 
      String aForename, String aSurname) 
   {  title = aTitle;
      forename = aForename;
      surname = aSurname;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the title from this name.
    *
    * @return the title from this name.
    */
   public String getTitle()
   {  return title;
   }

   /**
    * Returns the forename from this name.
    *
    * @return the forename from this name.
    */
   public String getForename()
   {  return forename;
   }

   /**
    * Returns the surname from this name.
    *
    * @return the surname from this name.
    */
   public String getSurname()
   {  return surname;
   }

   /**
    * Returns the initials of this name.
    *
    * @return the initials of this name.
    */
   public String getInitials()
   {  return forename.substring(0, 1) + "." + 
         surname.substring(0, 1) + ".";
   }

   /**
    * Returns the full name.
    *
    * @return the full name.
    */
   public String getFullName()
   {  return title + " " + forename +
         " " + surname;
   }

   /**
    * Returns the surname and forename 
    * (in that order).
    *
    * @return the surname and forename.
    */
   public String getLastFirst()
   {  return surname + ", " + forename;
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Sets the title in this name to the 
    * specified title.
    *
    * @param aTitle the specified title in 
    * this name.
    */
   public void setTitle(String aTitle)
   {  title = aTitle;
   }

   /**
    * Sets the forename in this name to the 
    * specified forename.
    *
    * @param aForename the specified forename 
    * in this name.
    */
   public void setForename(String aForename)
   {  forename = aForename;
   }

   /**
    * Sets the surname in this name to the 
    * specified surname.
    *
    * @param aSurname the specified surname 
    * in this name.
    */
   public void setSurname(String aSurname)
   {  surname = aSurname;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The person's title.
    */
   private String title;
 
   /**
    * The person's forename.
    */
   private String forename;

   /**
    * The person's surname.
    */
   private String surname;
}