/**
 * A class that represents locations on the earth's surface.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class Location
{  
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new location object with the give longitude & latitude.
    *
    * @param aLongitude longitudinal position.
    * @param aLatitude latitudinal position.
    */
   public Location(int aLongitude, 
      int aLatitude)
   {  longitude = aLongitude;
      latitude = aLatitude;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns this location's longitude.
    *
    * @return this location's longitude.
    */
   public int getLongitude()
   {  return longitude;
   }

   /**
    * Returns this location's latitude.
    *
    * @return this location's latitude.
    */
   public int getLatitude()
   {  return latitude;
   }

   /**
    * Returns a string representation of this location.
    *  
    * @return a string represeting this location.
    */
   public String toString()
   {  return longitude + ", " + latitude;
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Updates this location with new longitude & latitude.
    *
    * @param aLongitude new longitudinal position.
    * @param aLongitude new latitudinal position.
    */
   public void move(int aLongitude,
      int aLatitude)
   {  longitude = aLongitude;
      latitude = aLatitude;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * This location's longitude.
    */
   private int longitude;

   /**
    * This location's latitude.
    */
   private int latitude;
}