/**
 * A class that represents ticket objects.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class Ticket
{
/* =====================================
       CONSTRUCTORS
   =====================================
*/

   /**
    * Allocates a new Ticket object with
    * the given occasion and time.
    *
    * @param anOccasion the event this
    * ticket admits you to.
    * @param aTime the timing of the
    * event.
    */
   public Ticket(String anOccasion,
      String aTime)
   {  occasion = anOccasion;
      time = aTime;
      textWidth = Math.max(
         occasion.length(), 
         time.length());
   }

/* ===================================== 
       PUBLIC INTERFACE
   =====================================
*/

/* ---Getters------------------------ */

   /**
    * Displays a copy of this ticket.
    *
    */
   public void display()
   {  /* The horizontal lines must be
         as long as the maximum text 
         width plus the size of the left
         and right borders (2).
       */
      drawHorizLine(textWidth + 2, 
         HORIZ_BORDER);
      drawTextLine(occasion);
      drawTextLine(time);
      drawHorizLine(textWidth + 2, 
         HORIZ_BORDER);
   } 

   /**
    * Displays the specified number of 
    * copies of this ticket.
    *
    * @param aNum the number of copies.
    */
   public void display(int aNum)
   {  for (int i = 0; i < aNum; i++)
      {  display();
         System.out.println();
      }
   }   

/* =====================================
       HELPER METHODS 
   =====================================
*/

   /**
    * Displays a line containing the specified 
    * text plus a border.
    *
    * @param theText the text to be displayed.
    */
   private void drawTextLine(String theText)
   {  System.out.println(VERT_BORDER +
         padString(theText, ' ', textWidth) +
         VERT_BORDER);
   }

   /**
    * Displays a line containing the specified
    * number of the specified character.
    *
    * @param aNumOfChars the number of characters
    * to display.
    * @param aChar the character to display.
    */
   private static void drawHorizLine(
      int aNumOfChars, char aChar)
   {  for (int i = 0; i < aNumOfChars; i++)
      {  System.out.print(aChar);
      }
      System.out.println();
   }

   /**
    * Pads a given string with a prefix and suffix
    * of the specified character to give a string
    * of the specified length.
    *
    * @param str the string to pad.
    * @param aChar the character to use in the padding.
    * @param reqdLength the required final length; must be
    * less than str.length().
    * @return the padded string.
    */
   private static String padString(
      String str, char aChar, int reqdLength)
   {  String paddedStr = "";
      int amntOfPadding = 
         reqdLength - str.length();
      int leftPad = amntOfPadding / 2;
      int rightPad = (int) 
         (Math.round(amntOfPadding / 2.0));
      for (int i = 0; i < leftPad; i++)
      {  paddedStr = paddedStr + aChar;
      }
      paddedStr = paddedStr + str;
      for (int i = 0; i < rightPad; i++)
      {  paddedStr = paddedStr + aChar;
      }
      return paddedStr;
   }


/* =========================================
       INSTANCE VARIABLES  & CLASS VARIABLES
   =========================================
*/
   /**
    *  A description of the event.
    */
   private String occasion; 
   
   /**
    * A description of the start/end date/time.
    */
   private String time; 

   /**
    * The maximum number of characters wide 
    * this ticket is (excluding borders).
    */
   private int textWidth; 

   /**
    * The horizontal border of a ticket.
    */
   private static final char HORIZ_BORDER = '-';

   /**
    * The vertical border of a ticket.
    */
   private static final char VERT_BORDER = '|';
   
}