<?php
    require_once( 'output_functions.php' );
    
    // If this is an on-going session, obtain the $cart array.
    // If it's a new session, create an empty array
    session_start();
    if ( isset($_SESSION['cart']) )
    {
	    $cart = $_SESSION['cart'];
    }
    else
    {
	    $cart = array();
    }
    
    output_header( 'Your cart', 'sbw.css' );
    
    // Connect to database
    $dbconnection = mysqli_connect( $host, $user, $password, $dbname );
    if ( ! $dbconnection )
    {
        output_paragraph( 'We are undergoing scheduled maintenance.' );
    }
    elseif ( count($cart) == 0 )
    {
	    output_paragraph( 'No items in shopping cart.' );
    }
    else
    {
	    $total = 0;
	    echo "<table>";
	    foreach ($cart as $id => $qty)
	    {
		    // Get details of the wine whose id is in the cart
		    $sql = "SELECT * FROM wines WHERE id = {$id};";
		    $dbresult = mysqli_query( $dbconnection, $sql );
		    if ( $dbresult )
		    {
		        $row = mysqli_fetch_assoc( $dbresult );
		        echo "<tr>
			        	<td>{$row['name']}</td>
				        <td>{$row['price']}</td>
				        <td>{$qty}</td>
			          </tr>";
		        $total += $row['price'] * $qty;
	        }
	    }
	    echo "</table>";
	    output_paragraph( "TOTAL: {$total}" );        
    }
?>

    <p>
        <a href="show_catalog.php">Show catalog</a>
    </p>

<?php
    output_footer( 'Shrine of Bacchus Wines' );
?>
