import java.awt.event.*;

/**
 * A class that represents objects that add items to burger bar orders
 * in response to button clicks.
 * @author Derek Bridge
 */
public class AddItemToOrderListener
   implements ActionListener
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new listener object for adding an item to a burger bar
    * order in response to button clicks.
    *
    * @param theItem the dish being ordered.
    * @param theBurgerBar the burger bar where the order is being taken.
    */
   public AddItemToOrderListener(AbstractDish theItem, 
      BurgerBar theBurgerBar)
   {  item = theItem;
      burgerBar = theBurgerBar;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/
   /**
    * Tells the Burger Bar model to add the item to its order.
    * Invoked in response to button clicks.
    *
    * @param ae the button click event.
    */
   public void actionPerformed(ActionEvent ae)
   {  burgerBar.addItemToOrder(item);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private AbstractDish item;
   private BurgerBar burgerBar;
}