package datastructs;

import utilities.PreconditionException;

/**
 * A class that represents exceptions that are thrown when a
 * method is incorrectly invoked on an empty sequence data structure.
 * @author Derek Bridge
 */
public class EmptySequenceException
   extends PreconditionException
{
   /**
    * The exception without a message.
    */
   public EmptySequenceException()
   {  super();
   }

   /**
    * The exception with a message.
    *
    * @param msg the message.
    */
   public EmptySequenceException(final String msg)
   {  super(msg);
   }
}