/**
 * A class that demonstrates the operation of a number of 
 * standalone TLUs.
 * @author Derek Bridge
 */
public class TLUDemo
{
   public static void main(String[] args)
   {  /* Set up a TLU that computes s1 AND s2.
         The threshold, which (negated) becomes s0's weight, is 1.5.
         The other weights are both 1.
       */
      double[] andWeights = {1.0, 1.0};
      StandaloneTLU andTLU = new StandaloneTLU(1.5, 2, andWeights);
      System.out.println("AND\n===");
      activateOn4Inputs(andTLU);

      /* Set up a TLU that computes s1 OR s2.
         The threshold is 1.5, and the weights are both 1.
       */
      double[] orWeights = {1.0, 1.0};
      StandaloneTLU orTLU = new StandaloneTLU(0.5, 2, orWeights);
      System.out.println("OR\n==");
      activateOn4Inputs(orTLU);

      /* Set up a TLU that computes s1 IMPLIES s2.
         The threshold is 0, and the weights are both -1 and 1 resp.
       */
      double[] condWeights = {-1.0, 1.0};
      StandaloneTLU condTLU = new StandaloneTLU(0.0, 2, condWeights);
      System.out.println("CONDITIONAL\n===========");
      activateOn4Inputs(condTLU);

      /* Set up a TLU that computes NOT s1.
         The threshold is -0.5, and the weight is -1.
       */
      double[] notWeights = {-1.0};
      StandaloneTLU notTLU = new StandaloneTLU(-0.5, 1, notWeights);
      System.out.println("NOT\n===");
      activateOn2Inputs(notTLU);
   }

   private static void activateOn4Inputs(StandaloneTLU aTLU)
   {  double[] inputs = new double[2];
      for (int i = 0; i < 2; i++)
      {  inputs[0] = i;
         for (int j = 0; j < 2; j++)
         {  inputs[1] = j;
            System.out.println(i + " " + j + ": " + aTLU.activate(inputs));
         }
      }
      System.out.println();
   }

   private static void activateOn2Inputs(StandaloneTLU aTLU)
   {  double[] inputs = new double[1];
      inputs[0] = 0;
      System.out.println("0: " + aTLU.activate(inputs));
      inputs[0] = 1;
      System.out.println("1: " + aTLU.activate(inputs));
      System.out.println();
   }
}
