/**
 * A class for carrying out state space search but which discards any
 * successor that revisits its parent or grandparent. (This outlaws 
 * undo operations and reversible operations.)
 * @author Derek Bridge
 */
public class StateSpaceSearchWithNoUndos
   extends StateSpaceSearch
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new object that can carry out state space search
    * but which disallows undo operations or reversible operations.
    * @param theInitialState the initial state in this state space.
    */
   public StateSpaceSearchWithNoUndos(IState theInitialState)
   {  super(theInitialState);
   }

/* =======================================================================
       HELPER METHODS
   =======================================================================
*/
   /**
    * Adds a node to the agenda but not if its state is one we've just 
    * come from.
    * @param theAgenda the agenda we're adding to.
    * @param theNode the node we're adding.
    */
   protected void addNode(IAgenda theAgenda, Node theNode)
   {  Node parent = theNode.getParent();
      Node grandParent = null;
      if (parent != null)
      {  grandParent = parent.getParent();
      }
      if (((parent == null) || 
           (! parent.getState().equals(theNode.getState()))) &&
          ((grandParent == null) ||
           (! grandParent.getState().equals(theNode.getState()))))
      {  super.addNode(theAgenda, theNode);
      }
   }
}
