import java.util.*;

/**
 * A class that represents agenda for various searches of a
 * state space where the nodes to be expanded are stored in
 * a priority-ordered queue.
 * @author Derek Bridge
 */
public class PriorityQueueAgenda
   extends QueueAgenda
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /** 
    * Allocates a new priority queue agenda.
    * @param theComparator an object that contains methods that
    * enable us to compare two nodes.
    */
   public PriorityQueueAgenda(NodeComparator theComparator)
   {  super();
      comparator = theComparator;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Setters----------------------------------------------------------- */

   /**
    * Adds a node to the agenda (in its rightful place according to its
    * priority).
    * @param theNode the node being added.
    */
   public void addNode(Node theNode)
   {  Iterator iter = queue.iterator();
      int i = 0;
      while (iter.hasNext())
      {  Node queuedNode = (Node) iter.next();
         if (comparator.isLessThan(theNode, queuedNode))
         {  queue.add(i, theNode);
            return;
         }
         i++;
      }
      queue.add(theNode);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private NodeComparator comparator;
}
