import java.util.*;

/**
 * A class for comparing search tree nodes using the heuristic values
 * of the states that label these nodes.
 * @author Derek Bridge
 */
public class NodeGreedyComparator
   extends NodeComparator
{

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns true if one node is less than another, according to
    * the heuristic values of their states.
    */
   public boolean isLessThan(Node aNode, Node otherNode)
   {  return aNode.getState().getHeuristicValue() < 
         otherNode.getState().getHeuristicValue();
   }
}
