import java.util.*;

/**
 * A class that represents agenda for depth-bounded depth-first search of a
 * state space (stacks with a depth limit).
 * @author Derek Bridge
 */
public class DepthBoundedAgenda
   extends StackAgenda
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /** 
    * Allocates a new agenda for depth-bounded depth-first search.
    * @param theDepthLimit the depth limit.
    */
   public DepthBoundedAgenda(int theDepthLimit)
   {  super();
      depthLimit = theDepthLimit;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Setters----------------------------------------------------------- */

   /**
    * Adds a node to the agenda.
    * @param theNode the node being added.
    */
   public void addNode(Node theNode)
   {  if (theNode.getDepth() <= depthLimit)
      {  super.addNode(theNode);
      }
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private int depthLimit;
}
