import java.util.*;

/**
 * A class that represents reactive wall following agents that inhabit 
 * grid-like worlds and that are implemented using neural networks.
 * As written at the moment, it uses only my fully-connected, two layered,
 * feedforward nets.
 * @author Derek Bridge
 */
public class NeuralWallFollowingAgent
   extends NeuralNetAgent
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new neural wall following agent.
    * @param theNet the network that encodes this agent's action function.
    * Client code is responsible for ensuring that this net has 8 input
    * units (excluding the `extra' one) and two output units.
    */
   public NeuralWallFollowingAgent(TwoLayerNet theNet)
   {  super(theNet);
      for (int i = 0; i < World.NUM_OF_COMPASS_POINTS; i++)
      {  hasTouchSensor[i] = true;
      }
      physObjectGraphic = new PacmanGraphic(this);
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Setters----------------------------------------------------------- */

   /**
    * Forms an array of doubles from the sensor readings for
    * input to the net. For this agent, we use only the touch
    * sensors, and we convert their boolean readings into
    * doubles.
    * @return the array of inputs to the net.
    */
   public double[] createNetInputs()
   {  double[] inputs = new double[8];
      inputs[0] = touchReading[FRONT] ? 1 : 0;
      inputs[1] = touchReading[FRONT_RIGHT] ? 1 : 0;
      inputs[2] = touchReading[RIGHT_SIDE] ? 1 : 0;
      inputs[3] = touchReading[BACK_RIGHT] ? 1 : 0;
      inputs[4] = touchReading[BACK] ? 1 : 0;
      inputs[5] = touchReading[BACK_LEFT] ? 1 : 0;
      inputs[6] = touchReading[LEFT_SIDE] ? 1 : 0;
      inputs[7] = touchReading[FRONT_LEFT] ? 1 : 0;
      return inputs;
   }

   /**
    * Takes the output of the net and works out which action
    * this signifies. 
    * @param theNetOutput the output of the net.
    * @return the action.
    */
   public Action decodeNetOutputs(double[] theNetOutput)
   {  /* 0,0 is Move
         0,1 is Turn right
         1,0 is Turn left
         But outputs of exactly 0 and 1 are unlikely so we
         take a very generous interpretation here.
       */
      if (theNetOutput[0] < 0.5 && theNetOutput[1] < 0.5)
      {  return new Move();
      }
      if (theNetOutput[0] < 0.5 && theNetOutput[1] >= 0.5)
      {  return new Turn(Turn.RIGHT, 2);
      }
      if (theNetOutput[0] >= 0.5 && theNetOutput[1] < 0.5)
      {  return new Turn(Turn.LEFT, 2);
      }
      return new NullAction();
    }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   protected TwoLayerNet net;
}
