import java.util.*;

/**
 * A class that demonstrates the learning, using back-prop, and use
 * of a net for predicting the class of an Iris plant.
 * @author Derek Bridge
 */
public class IrisLearningDemo
{
   public static void main(String[] args)
   {  Map examples = LearningUtilities.readExamples(
         "iris.data", // file name
         4,           // number of input attributes
         2            // number of output attributes
         );
      /* Experiment with a number of different hidden units.
       */
      for (int j = 5; j <= 15; j += 5)
      {  System.out.println("Iris data: " + j + " hidden units");
         BackProp bp = new BackProp(
            4, // number of input units
            j, // number of hidden units
            2  // number of output units
            );
         Map trainingSet = new Hashtable();
         Map testSet = new Hashtable();
         LearningUtilities.splitData(
            examples, // the examples to split
            66, // 2/3 to be the training set; 1/3 in the test set
            trainingSet, testSet);
         bp.backProp(
            1000, // number of epochs
            0.35, // the learning rate
            trainingSet, 
            1,    // how much output we want (1 = start and final nets)
            testSet, 
            1     // how often to test the net (1 = after all training)
            );
      }
   }
}
