import java.util.*;

/**
 * A class that demonstrates the learning, using back-prop, of a
 * net for computing exclusive-or.
 * @author Derek Bridge
 */
public class XORLearningDemo
{
   public static void main(String[] args)
   {  /* Prepare to train a net with 2 input units, 3 hidden
         units and 1 output unit (excluding `extras')
       */
      BackProp bp = new BackProp(2, 3, 1);
      /* Set up example inputs and target outputs for XOR.
       */
      Map trainingSet = new Hashtable();
      double[] i1 = {0.0, 0.0};
      double[] t1 = {0.1};
      trainingSet.put(i1, t1);
      double[] i2 = {0.0, 1.0};
      double[] t2 = {0.9};
      trainingSet.put(i2, t2);
      double[] i3 = {1.0, 0.0};
      double[] t3 = {0.9};
      trainingSet.put(i3, t3);
      double[] i4 = {1.0, 1.0};
      double[] t4 = {0.1};
      trainingSet.put(i4, t4);
      /* The test set is the same as the training set in this example.
       */
      Map testSet = trainingSet;
      /* Run the training algorithm.
       */
      bp.backProp(
         0.1, // the allowable error
         0.35, // the learning rate
         trainingSet, 
         1,    // how much output we want (1 = initial and final nets)
         testSet, 
         1     // how often to test the net (1 = after all training)
         );
   }
}
