/**
 * A class that represents threshold logic units (TLUs).
 * These are for use in the hidden layer of fully-connected,
 * two-layered, feedforward networks. But they receive no input.
 * They are the units that enable us to replace thresholds
 * by extra input lines.
 * @author Derek Bridge
 */
public class DummyTLU
   extends HiddenLayerTLU
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new TLU that takes in no inputs.
    */
   public DummyTLU()
   {  /* The values supplied to the superclass constructors are
         all dummy values. No use is made of any of these herein.
       */
      super(0, null);
      output = 1.0;
      gradient = 0;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Computes the activation (output) of this TLU.
    * It always returns 1.
    * @param s an array of sensor values (the inputs to this TLU).
    * This parameter can be null or of any length and contents that
    * you like: it is ignored. We keep it here for compatibility
    * with the superclass, whose method we are overriding here.
    */
   public double activate(double[] s)
   {  return 1.0;
   }
}
