package world;
import java.util.*;

/**
 * A class that represents grid-like worlds containing walls of bricks.
 * @author Derek Bridge
 */
public class WalledWorld
   extends World
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new world with given dimensions.
    * @param theWidth the width of the world.
    * @param theHeight the height of the world.
    * @param theScaleFactor the scale factor used for displaying the world.
    */
   public WalledWorld(int theWidth, int theHeight, int theScaleFactor)
   {  super(theWidth, theHeight, theScaleFactor);
   }
      
/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Setters----------------------------------------------------------- */

   /**
    * Builds a horizontal wall, adding it to an existing list of objects.
    * It is assumed that clients will not try to build walls into occupied
    * cells!
    * @param y which row it is drawn in.
    * @param x0 starting column
    * @param x1 final column
    * @param objects the existing objects in the world, to which we are adding.
    */
   protected List buildHorizontalWall(int y, int x0, int x1, List objects)
   {  Brick b = null;
      for (int x = x0; x <= x1; x++)
      {  b = new Brick();
         b.setCell(cells[x][y]);
         cells[x][y].addObject(b);
         objects.add(b);
      }
      return objects;
   }

   /**
    * Builds a vertical wall, adding it to an existing list of objects.
    * It is assumed that clients will not try to build walls into occupied
    * cells!
    * @param x which column it is drawn in.
    * @param y0 starting row
    * @param y1 final row
    * @param objects the existing objects in the world, to which we are adding.
    */
   protected List buildVerticalWall(int x, int y0, int y1, List objects)
   {  Brick b = null;
      for (int y = y0; y <= y1; y++)
      {  b = new Brick();
         b.setCell(cells[x][y]);
         cells[x][y].addObject(b);
         objects.add(b);
      }
      return objects;
   }
}
