package world;
import java.io.*;
import gui.*;

/**
 * A class that represents physical objects in worlds. (Subclasses
 * may include bricks, agents, wood chips, scraps of food, etc.)
 * @author Derek Bridge
 */
public abstract class PhysObject
   implements Serializable
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new physical object at a given cell.
    */
   public PhysObject()
   {  spaceUsed = DEFAULT_SPACE_USED;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns this object's Gui component.
    */
   public PhysObjectGraphic getPhysObjectGraphic()
   {  return physObjectGraphic;
   }

   /**
    * Returns the cell in which the physical object presently resides.
    */
   public Cell getCell()
   {  return cell;
   }

   /**
    * Returns the proportion of cell space that this agent occupies [0,1].
    */
   public float getSpaceUsed()
   {  return spaceUsed;
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Sets this object's Gui component.
    * @param theGraphic the Gui component.
    */
   public void setPhysObjectGraphic(PhysObjectGraphic theGraphic)
   {  physObjectGraphic = theGraphic;
   }

   /**
    * Sets the object's cell.
    * @param theCell the new cell for the object.
    */
   public void setCell(Cell theCell)
   {  cell = theCell;
   }
   
   /**
    * Sets the proportion of cell space used by this object.
    * @param theSpaceUsed the proportion of space used [0,1].
    */
   public void setSpaceUsed(float theSpaceUsed)
   {  spaceUsed = theSpaceUsed;
   }

   /**
    * What to do on each clock tick.
    * @param theTime an integer representing how many ticks have passed.
    */
   public abstract void onTick(int theTime);

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   protected PhysObjectGraphic physObjectGraphic;
   protected Cell cell;
   protected float spaceUsed;

   private static final float DEFAULT_SPACE_USED = 1.0f;
}
