package actions;
import world.*;

/**
 * A class that represents turn actions by agents that inhabit grid-like worlds.
 * @author Derek Bridge
 */
public class Turn
   extends Action
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new turn action.
    * @param theTurnDirection which way to turn (left or right).
    * The agent will turn only 45 degrees on any turn.
    * (The implementation relies on legitimate parameter values.)
    */
   public Turn(int theTurnDirection)
   {  turnDirection = theTurnDirection;
      numOfTurns = 1;
   }

   /**
    * Allocates a new turn action.
    * @param theTurnDirection which way to turn (left or right).
    * @param theNumOfTurns the number of 45 degree turns to make
    * (to allow the agent to swing round to any compass point).
    * (The implementation relies on legitimate prameter values.)
    */
   public Turn(int theTurnDirection, int theNumOfTurns)
   {  turnDirection = theTurnDirection;
      numOfTurns = theNumOfTurns;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Public constants-------------------------------------------------- */

   public static final int LEFT = 0;
   public static final int RIGHT = 1;

/* --Getters----------------------------------------------------------- */

   /**
    * Returns a string representation of this expression.
    */
   public String toString()
   {  int angle = numOfTurns * 45;
      return turnDirection == LEFT ? "turn" + angle + "left" :
         "turn" + angle + "right";
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Set the turn direction and number of turns.
    * @param theTurnDirection which way to turn (left or right).
    * @param theTurnAmount the number of 45 degree turns to make
    * (to allow the agent to swing round to any compass point).
    * (The implementation relies on legitimate prameter values.)
    */
   public void setTurn(int theTurnDirection, int theNumOfTurns)
   {  turnDirection = theTurnDirection;
      numOfTurns = theNumOfTurns;
   }

   /**
    * Carry out the action in the world.
    * @param theAgent the agent who is to carry out this action.
    */
   public void execute(Agent theAgent)
   {  int direction = theAgent.getDirection();   
      if (turnDirection == LEFT)
      {  direction = World.spin(direction, numOfTurns);
      }
      else // RIGHT
      {  direction = World.spin(direction, -numOfTurns);
      }
      theAgent.setDirection(direction);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private int turnDirection;
   private int numOfTurns;
}
