package proplogic;
import java.util.*;

/**
 * A class that represents Boolean expressions that comprise a binary
 * operator applied to two Boolean expressions.
 * @author Derek Bridge
 */
public abstract class BinaryBooleanExpression
   extends BooleanExpression
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a Boolean expression involving a binary operator.
    * @param anArgumentExpression1 one expression the binnary operator
    * is being applied to.
    * @param anArgumentExpression2 the other expression the binnary operator
    * is being applied to.
    */
   public BinaryBooleanExpression(BooleanExpression anArgumentExpression1,
      BooleanExpression anArgumentExpression2)
   {  argumentExpression1 = anArgumentExpression1;
      argumentExpression2 = anArgumentExpression2;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   protected BooleanExpression argumentExpression1;
   protected BooleanExpression argumentExpression2;
}
