package gui;
import java.awt.*;
import world.*;

/**
 * A class that represents Gui components typically for agents in grid-like 
 * worlds.
 * @author Derek Bridge
 */
public class PacmanGraphic
   extends PhysObjectGraphic
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new Gui pacman component for a given physical object.
    * @param theAgent the agent whose Gui component we are creating.
    */
   public PacmanGraphic(Agent theAgent)
   {  super(theAgent);
      mouthAngle = DEFAULT_PACMAN_MOUTH_ANGLE;
      colour = DEFAULT_PACMAN_COLOUR;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Setters----------------------------------------------------------- */

   /**
    * Draws this component on the graphics context at the given position.
    */
   public void draw(Graphics g, int x, int y)
   {  g.setColor(colour);
      g.fillArc(x, y, 1, 1,
         ((Agent)object).getDirection() * 45 + mouthAngle / 2, 360 - mouthAngle);
   }

   /**
    * Sets this pacman's mouth angle.
    * @param theMouthAngle how wide the mouth is.
    */
   public void setMouthAngle(int theMouthAngle)
   {  mouthAngle = theMouthAngle;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   private int mouthAngle;

   private static final int DEFAULT_PACMAN_MOUTH_ANGLE = 30;
   private static final Color DEFAULT_PACMAN_COLOUR = Color.red;
}
