package ga;

/**
 * An interface that defines a factory class for supplying worlds and agents
 * to a generic genetic algorithm.
 * @author Derek Bridge
 */
public interface IGAFactory
{
   /**
    * Returns a world of an appropriate kind in which evolved agents
    * will be tested.
    */
   public IGAWorld createWorld();

   /**
    * Returns an agent of an appropriate kind (typically a randomly
    * generated agent) from which other agents will be evolved.
    */
   public IGAAgent createAgent();
}
