package demos;
import world.*;

/**
 * A class that represents agents that sit in cells and set a boolean if
 * another agent ever visits that cell.
 * @author Derek Bridge
 */
public class CellMonitorAgent
   extends ProceduralAgent
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new cell monitor agent.
    */
   public CellMonitorAgent()
   {  spaceUsed = 0.0f;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns true if this cell has been visited so far.
    */
   public boolean wasVisited()
   {  return wasVisited;
   }

/* --Setters----------------------------------------------------------- */

   /**
    * What to do on each clock tick.
    * @param theTime an integer representing how many ticks have passed.
    */
   public void onTick(int theTime)
   {  /* If you haven't been visited already, see whether you've
         been visited this time.
       */
      if (! wasVisited)
      {  wasVisited = cell.someSpaceIsInUse();
      }
   }

   /**
    * Sets (and especially resets) whether this cell has been visited
    * so far.
    * @param theStatus the new status.
    */
   public void setWasVisited(boolean theStatus)
   {  wasVisited = theStatus;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private boolean wasVisited;
}
