/**
 * A class that represents simple bank accounts.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class BankAccount
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new bank account object 
    *  with the given opening balance.
    *
    * @param theBranch the branch where this
    * account is held.
    * @param anOpeningBalance the opening
    * balance.
    */
   public BankAccount(String theBranch,
      int anOpeningBalance)
   {  branch = theBranch;
      currentBalance = anOpeningBalance;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the current balance.
    *
    * @return the current balance.
    */
   public int getCurrentBalance()
   {  return currentBalance;
   }

   /**
    * Returns the branch where the
    * account is held.
    *
    * @return the branch where the
    * account is held.
    */
   public String getBranch()
   {  return this.branch;
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Credit the account with the specified
    * amount.
    *
    * @param anAmount the amount by which
    * to credit this account.
    */
   public void credit(int anAmount)
   {  currentBalance += anAmount;
   }

   /**
    * Debit the account by the specified
    * amount.
    *
    * @param anAmount the amount by which
    * to debit this account.
    */
   public void debit(int anAmount)
   {  this.currentBalance -= anAmount;
   }

   /**
    * Transfer the specified amount from
    * this account to the specified account.
    *
    * @param anAmount the amount to transfer.
    * @param theDestinationAccount the
    * account to be credited.
    */
   public void transfer(int anAmount,
      BankAccount theDestinationAccount)
   {  this.debit(anAmount);
      theDestinationAccount.credit(anAmount);
   }

   /**
    * Sets the branch where this account is
    * held to the specified branch.
    */
   public void setBranch(String branch)
   {  this.branch = branch;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The branch where this account is held.
    */
   private String branch; 

   /**
    * The current balance.
    */
   private int currentBalance; 
}