import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A JLabel with an animated icon.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class PoliteAnimatedLabel
   extends JLabel
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new animated label object.
    */
   public PoliteAnimatedLabel()
   {  super();
      images = new ImageIcon[10];
      for (int i = 0; i < NUM_OF_IMAGES; i++)
      {  images[i] = new ImageIcon("duke" + i + ".gif");
      }
      timer = new Timer(50,
         new ActionListener()
         {  public void actionPerformed(ActionEvent ae)
            {  frameNumber++;
               setIcon(images[frameNumber % NUM_OF_IMAGES]);
            }
         });
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/
   /**
    * Starts the time that controls the animation.
    */
   public synchronized void startAnimation()
   {  timer.start();
   }

   /**
    * Stops the timer that controls the animation.
    */
   public synchronized void stopAnimation()
   {  timer.stop();
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The timer that controls the animation.
    */
   private Timer timer;

   /**
    * An index to the array of images.
    */
   private int frameNumber = -1;


   /**
    * The array of images.
    */
   private ImageIcon[] images;

   /**
    * The number of images in the array.
    */
   private static final int NUM_OF_IMAGES = 10;

/* =======================================================================
       TEST DRIVER
   =======================================================================
*/
   public static void main(String[] args)
   {  JFrame frame = new JFrame("Animation Demo");
      final PoliteAnimatedLabel lbl = new PoliteAnimatedLabel();
      Container contentPane = frame.getContentPane();
      contentPane.add(lbl);
      frame.addWindowListener(new WindowAdapter()
      {  public void windowIconified(WindowEvent we)
         {  lbl.stopAnimation();
         }

         public void windowDeiconified(WindowEvent we)
         {  lbl.startAnimation();
         }

         public void windowClosing(WindowEvent we)
         {  System.exit(0);
         }
      });
      frame.pack();
      frame.setVisible(true);
      lbl.startAnimation();
   }
}
