import java.util.*;
import javax.swing.*;

/**
 * A class that represents burger bars. Each burger bar object has
 * a bill-of-fare (the shit they have on offer).
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class BurgerBar
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new burger bar.
    */
   public BurgerBar()
   {  currentOrder = new DefaultListModel();
      /* You would now read the bill of fare in from a file.
         That way, different burger bars can easily have
         different bills of fare (by reading from different
         files). And a burger bar can easily modify its bill
         of fare over time (by changing what's in the file)
         e.g. to reflect availablility of ingredients or tie-ins
         with the latest Lion King  movie ("You've enjoyed
         Disney's "Lion King VII -- Now Try our Mangy Mane
         Burgers")
         For simplicity, however, we'll hard-code the bill-of-fare.
       */
      billOfFare = new ArrayList(3);
      List ourBurgers = new ArrayList(3);
      ourBurgers.add(new Burger("Aardvark Burger", 123));
      ourBurgers.add(new Burger("Wombat Burger", 89));
      ourBurgers.add(new Burger("Mulch Burger", 22));
      List ourSideDishes = new ArrayList(3);
      ourSideDishes.add(new SideDish("Greasy chips", 70));
      ourSideDishes.add(new SideDish("Mash", 33));
      ourSideDishes.add(new SideDish("Very greasy chips", 75));
      List ourDrinks = new ArrayList(3);
      ourDrinks.add(new Drink("Tap water", 176));
      ourDrinks.add(new Drink("Rain water", 254));
      ourDrinks.add(new Drink("Mulch juice", 13));
      billOfFare.add(ourBurgers);
      billOfFare.add(ourSideDishes);
      billOfFare.add(ourDrinks);
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* ---Getters---------------------------------------------------------- */

   /**
    * Returns this burger bar's bill-of-fare.
    *
    * @return the bill-of-fare on offer in this burger bar.
    */
   public List getBillOfFare()
   {  return billOfFare;
   }

   /**
    * Returns this burger bar's order for the current customer.
    *
    * @return the current customer order
    */
   public ListModel getCurrentOrder()
   {  return currentOrder;
   }

/* ---Setters---------------------------------------------------------- */

   /**
    * Adds an item to the current customer order.
    * 
    * @param theItem the item being added to the order.
    */
   public void addItemToOrder(AbstractDish theItem)
   {  currentOrder.add(0, theItem);
   }

   /**
    * Removes a specified item from the current customer order.
    *
    * @param theItemIndex the position in the order of the item being removed.
    */
   public void removeItemFromOrder(int theItemIndex)
   {  AbstractDish item = (AbstractDish) currentOrder.get(theItemIndex);
      currentOrder.remove(theItemIndex);
   }

   /**
    * Finalises the present customer's order by resetting variables 
    * for the next customer.
    */
   public void concludeOrder()
   {  currentOrder.clear();
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   /**
    * This burger bar's bill-of-fare.
    */
   private List billOfFare;

   /**
    * The current customer's order (a list of dishes).
    */
   private DefaultListModel currentOrder;
}


