import java.awt.event.*;

/**
 * A class that represents objects that add items to burger bar orders
 * in response to button clicks.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class AddItemToOrderListener
   implements ActionListener
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new listener object for adding an item to a burger bar
    * order in response to button clicks.
    *
    * @param theItem the dish being ordered.
    * @param theBurgerBar the burger bar where the order is being taken.
    */
   public AddItemToOrderListener(AbstractDish theItem, 
      BurgerBar theBurgerBar)
   {  item = theItem;
      burgerBar = theBurgerBar;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/
   /**
    * Tells the Burger Bar to add the item to its order.
    * Invoked in response to button clicks. (Since the order is
    * a data structure associated with a JList, the JList on
    * the screen will also automatically change.)
    *
    * @param ae the button click event.
    */
   public void actionPerformed(ActionEvent ae)
   {  burgerBar.addItemToOrder(item);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The dish being ordered.
    */
   private AbstractDish item;

   /**
    * The burger bar where the order is being taken.
    */
   private BurgerBar burgerBar;
}